/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.ObservableOptional;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.value.TransformOptionalExpression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import io.flutter.FlutterBundle;
import io.flutter.FlutterConstants;
import io.flutter.FlutterUtils;
import io.flutter.actions.InstallSdkAction;
import io.flutter.module.FlutterProjectType;
import io.flutter.module.settings.FlutterCreateParams;
import io.flutter.project.FlutterProjectModel;
import io.flutter.project.FlutterSettingsStep;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterProjectStep
extends SkippableWizardStep<FlutterProjectModel>
implements InstallSdkAction.Model {
    private final JBScrollPane myRootPanel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private final InstallSdkAction myInstallSdkAction;
    private boolean hasEntered;
    private OptionalValueProperty<FlutterProjectType> myProjectType;
    private StringValueProperty myDownloadErrorMessage;
    private InstallSdkAction.CancelActionListener myListener;
    private String mySdkPathContent;
    private JPanel myPanel;
    private JTextField myProjectName;
    private JTextField myDescription;
    private TextFieldWithBrowseButton myProjectLocation;
    private ComboboxWithBrowseButton myFlutterSdkPath;
    private JLabel myHeading;
    private JPanel myLocationPanel;
    private LinkLabel myInstallActionLink;
    private JProgressBar myProgressBar;
    private JLabel myCancelProgressButton;
    private JTextPane myProgressText;
    private FlutterCreateParams myCreateParams;
    private Color sdkBackgroundColor;

    public FlutterProjectStep(FlutterProjectModel model, String title, Icon icon, FlutterProjectType type) {
        super((WizardModel)model, title, icon);
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.hasEntered = false;
        this.myDownloadErrorMessage = new StringValueProperty();
        this.mySdkPathContent = "";
        this.myProjectType = new OptionalValueProperty((Object)type);
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myInstallSdkAction = new InstallSdkAction((InstallSdkAction.Model)this);
        this.myRootPanel = StudioWizardStepPanel.wrappedWithVScroll((JPanel)this.myValidatorPanel);
        FormScalingUtil.scaleComponentTree(((Object)((Object)this)).getClass(), (JComponent)this.myRootPanel);
    }

    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            FlutterProjectStep.$$$reportNull$$$0(0);
        }
        FlutterProjectModel model = (FlutterProjectModel)this.getModel();
        String initialLocation = WizardUtils.getProjectLocationParent().getPath();
        ((JTextField)this.myProjectLocation.getChildComponent()).setText(initialLocation);
        TextProperty locationText = new TextProperty((JTextComponent)this.myProjectLocation.getChildComponent());
        this.myBindings.bind((SettableValue)model.projectLocation(), (ObservableValue)locationText);
        this.myBindings.bindTwoWay((SettableValue)new TextProperty((JTextComponent)this.myProjectName), (SettableValue)model.projectName());
        this.myBindings.bind((SettableValue)model.description(), (ObservableValue)new TextProperty((JTextComponent)this.myDescription));
        this.myFlutterSdkPath.getComboBox().setEditable(true);
        this.myFlutterSdkPath.getButton().addActionListener(e -> this.myFlutterSdkPath.getComboBox().setSelectedItem(this.myFlutterSdkPath.getComboBox().getEditor().getItem()));
        this.myBindings.bind((SettableValue)model.flutterSdk(), (ObservableValue)new TransformOptionalExpression<String, String>("", (ObservableOptional)new SelectedItemProperty(this.myFlutterSdkPath.getComboBox())){

            @NotNull
            protected String transform(@NotNull String value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = value;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "io/flutter/project/FlutterProjectStep$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "io/flutter/project/FlutterProjectStep$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "transform";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "transform";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myBindings.bindTwoWay((SettableValue)model.isOfflineSelected(), (SettableValue)new SelectedProperty((AbstractButton)this.myCreateParams.getOfflineCheckbox()));
        this.myCreateParams.setInitialValues();
        FlutterSdkUtil.addKnownSDKPathsToCombo((JComboBox)this.myFlutterSdkPath.getComboBox());
        this.myFlutterSdkPath.addBrowseFolderListener(FlutterBundle.message((String)"flutter.sdk.browse.path.label", (Object[])new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
        this.myProjectLocation.addBrowseFolderListener(FlutterBundle.message((String)"flutter.module.create.settings.location.select", (Object[])new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myValidatorPanel.registerValidator((ObservableValue)model.flutterSdk(), FlutterProjectStep::validateFlutterSdk);
        this.myValidatorPanel.registerValidator((ObservableValue)model.projectName(), this::validateFlutterModuleName);
        this.myValidatorPanel.registerMessageSource((ObservableValue)this.myDownloadErrorMessage);
        if (this.isProject()) {
            Expression locationFile = model.projectLocation().transform(File::new);
            this.myValidatorPanel.registerValidator((ObservableValue)locationFile, (Validator)new PathValidator.Builder().withCommonRules().build("project location"));
            final JTextComponent sdkEditor = (JTextComponent)this.myFlutterSdkPath.getComboBox().getEditor().getEditorComponent();
            this.sdkBackgroundColor = sdkEditor.getBackground();
            sdkEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    FlutterProjectStep.this.updateSdkField(sdkEditor);
                }
            });
        } else {
            this.myCreateParams.getOfflineCheckbox().setText("Create module offline");
        }
        this.myProgressBar.setVisible(false);
        this.myProgressText.setVisible(false);
        this.myCancelProgressButton.setVisible(false);
        this.myInstallActionLink.setIcon(this.myInstallSdkAction.getLinkIcon());
        this.myInstallActionLink.setDisabledIcon(IconLoader.getDisabledIcon((Icon)this.myInstallSdkAction.getLinkIcon()));
        this.myInstallActionLink.setText(this.myInstallSdkAction.getLinkText());
        this.myInstallActionLink.setListener((label, linkUrl) -> this.myInstallSdkAction.actionPerformed(null), null);
        this.myProgressText.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.NORMAL).deriveFont(2));
        this.myCancelProgressButton.setCursor(Cursor.getPredefinedCursor(12));
        this.myCancelProgressButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FlutterProjectStep.this.myListener.actionCanceled();
            }
        });
    }

    private void updateSdkField(JTextComponent sdkEditor) {
        FlutterSdk current = FlutterSdk.forPath((String)sdkEditor.getText());
        Color color = this.sdkBackgroundColor;
        if (current == null) {
            color = ColorUtil.isDark((Color)this.sdkBackgroundColor) ? ColorUtil.darker((Color)JBColor.YELLOW, (int)5) : ColorUtil.desaturate((Color)JBColor.YELLOW, (int)15);
        }
        sdkEditor.setBackground(color);
    }

    @NotNull
    private Validator.Result validateFlutterModuleName(@NotNull String moduleName) {
        Project project;
        ProjectStructureConfigurable fromConfigurable;
        Module module;
        if (moduleName == null) {
            FlutterProjectStep.$$$reportNull$$$0(1);
        }
        if (moduleName.isEmpty()) {
            Validator.Result result = FlutterProjectStep.errorResult("Please enter a name for the " + this.getContainerName() + ".");
            if (result == null) {
                FlutterProjectStep.$$$reportNull$$$0(2);
            }
            return result;
        }
        File loc = new File(FileUtil.toSystemDependentName((String)((String)((FlutterProjectModel)this.getModel()).projectLocation().get())), (String)((FlutterProjectModel)this.getModel()).projectName().get());
        if (loc.exists()) {
            Validator.Result result = FlutterProjectStep.errorResult("Project location already exists: " + loc.getPath());
            if (result == null) {
                FlutterProjectStep.$$$reportNull$$$0(3);
            }
            return result;
        }
        if (!FlutterUtils.isValidPackageName((String)moduleName)) {
            Validator.Result result = FlutterProjectStep.errorResult("Invalid " + this.getContainerName() + " name: '" + moduleName + "' - must be a valid Dart package name (lower_case_with_underscores).");
            if (result == null) {
                FlutterProjectStep.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (FlutterUtils.isDartKeyword((String)moduleName)) {
            Validator.Result result = FlutterProjectStep.errorResult("Invalid module name: '" + moduleName + "' - must not be a Dart keyword.");
            if (result == null) {
                FlutterProjectStep.$$$reportNull$$$0(5);
            }
            return result;
        }
        if (FlutterConstants.FLUTTER_PACKAGE_DEPENDENCIES.contains(moduleName)) {
            Validator.Result result = FlutterProjectStep.errorResult("Invalid " + this.getContainerName() + " name: '" + moduleName + "' - this will conflict with Flutter package dependencies.");
            if (result == null) {
                FlutterProjectStep.$$$reportNull$$$0(6);
            }
            return result;
        }
        if (moduleName.length() > 30) {
            Validator.Result result = FlutterProjectStep.errorResult("Invalid " + this.getContainerName() + " name - must be less than " + 30 + " characters.");
            if (result == null) {
                FlutterProjectStep.$$$reportNull$$$0(7);
            }
            return result;
        }
        if (((Optional)((FlutterProjectModel)this.getModel()).project().get()).isPresent() && (module = (fromConfigurable = ProjectStructureConfigurable.getInstance((Project)(project = (Project)((FlutterProjectModel)this.getModel()).project().getValue()))) != null ? fromConfigurable.getModulesConfig().getModule(moduleName) : ModuleManager.getInstance((Project)project).findModuleByName(moduleName)) != null) {
            Validator.Result result = FlutterProjectStep.errorResult("A module with that name already exists in the project.");
            if (result == null) {
                FlutterProjectStep.$$$reportNull$$$0(8);
            }
            return result;
        }
        Validator.Result result = Validator.Result.OK;
        if (result == null) {
            FlutterProjectStep.$$$reportNull$$$0(9);
        }
        return result;
    }

    protected void hideLocation() {
        this.myLocationPanel.setVisible(false);
    }

    @NotNull
    public String getContainerName() {
        if ("project" == null) {
            FlutterProjectStep.$$$reportNull$$$0(10);
        }
        return "project";
    }

    protected boolean isProject() {
        return true;
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @NotNull
    protected JComponent getComponent() {
        JBScrollPane jBScrollPane = this.myRootPanel;
        if (jBScrollPane == null) {
            FlutterProjectStep.$$$reportNull$$$0(11);
        }
        return jBScrollPane;
    }

    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myProjectName;
    }

    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            FlutterProjectStep.$$$reportNull$$$0(12);
        }
        return observableBool;
    }

    protected void onEntering() {
        ((FlutterProjectModel)this.getModel()).projectType().set(this.myProjectType);
        if (this.hasEntered) {
            return;
        }
        String heading = "";
        switch ((FlutterProjectType)this.myProjectType.getValue()) {
            case APP: {
                heading = FlutterBundle.message((String)"module.wizard.app_step_body", (Object[])new Object[0]);
                break;
            }
            case PACKAGE: {
                heading = FlutterBundle.message((String)"module.wizard.package_step_body", (Object[])new Object[0]);
                break;
            }
            case PLUGIN: {
                heading = FlutterBundle.message((String)"module.wizard.plugin_step_body", (Object[])new Object[0]);
                break;
            }
            case MODULE: {
                heading = FlutterBundle.message((String)"module.wizard.module_step_body", (Object[])new Object[0]);
                break;
            }
            case IMPORT: {
                throw new Error("Import is handled in a different class");
            }
        }
        this.myHeading.setText(heading);
        this.myDownloadErrorMessage.set((Object)"");
        this.mySdkPathContent = (String)this.myFlutterSdkPath.getComboBox().getEditor().getItem();
        String descrText = "";
        String name = "";
        switch ((FlutterProjectType)this.myProjectType.getValue()) {
            case APP: {
                name = FlutterBundle.message((String)"module.wizard.app_name", (Object[])new Object[0]);
                descrText = FlutterBundle.message((String)"module.wizard.app_text", (Object[])new Object[0]);
                break;
            }
            case PACKAGE: {
                name = FlutterBundle.message((String)"module.wizard.package_name", (Object[])new Object[0]);
                descrText = FlutterBundle.message((String)"module.wizard.package_text", (Object[])new Object[0]);
                break;
            }
            case PLUGIN: {
                name = FlutterBundle.message((String)"module.wizard.plugin_name", (Object[])new Object[0]);
                descrText = FlutterBundle.message((String)"module.wizard.plugin_text", (Object[])new Object[0]);
                break;
            }
            case MODULE: {
                name = FlutterBundle.message((String)"module.wizard.module_name", (Object[])new Object[0]);
                descrText = FlutterBundle.message((String)"module.wizard.module_text", (Object[])new Object[0]);
                break;
            }
            case IMPORT: {
                throw new Error("Import is handled in a different class");
            }
        }
        this.myDescription.setText(descrText);
        this.myProjectName.setText(name);
        this.hasEntered = true;
    }

    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        ArrayList allSteps = Lists.newArrayList();
        if (this.myProjectType.getValue() == FlutterProjectType.PACKAGE) {
            ArrayList arrayList = allSteps;
            if (arrayList == null) {
                FlutterProjectStep.$$$reportNull$$$0(13);
            }
            return arrayList;
        }
        allSteps.add(new FlutterSettingsStep((FlutterProjectModel)this.getModel(), this.getTitle(), this.getIcon()));
        ArrayList arrayList = allSteps;
        if (arrayList == null) {
            FlutterProjectStep.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public void setSdkPath(String path) {
        this.mySdkPathContent = (String)this.myFlutterSdkPath.getComboBox().getEditor().getItem();
        this.myFlutterSdkPath.getComboBox().getEditor().setItem(path);
        this.myDownloadErrorMessage.set((Object)"");
    }

    public boolean validate() {
        this.setSdkPath(this.mySdkPathContent);
        FlutterProjectStep.ensureComboModelContainsCurrentItem(this.myFlutterSdkPath.getComboBox());
        return false;
    }

    public void requestNextStep() {
        FlutterProjectStep.ensureComboModelContainsCurrentItem(this.myFlutterSdkPath.getComboBox());
    }

    public void setErrorDetails(String details) {
        this.myDownloadErrorMessage.set((Object)(details == null ? "" : details));
    }

    public ComboboxWithBrowseButton getSdkComboBox() {
        return this.myFlutterSdkPath;
    }

    public void addCancelActionListener(InstallSdkAction.CancelActionListener listener) {
        this.myListener = listener;
    }

    public JProgressBar getProgressBar() {
        return this.myProgressBar;
    }

    public LinkLabel getInstallActionLink() {
        return this.myInstallActionLink;
    }

    public JTextPane getProgressText() {
        return this.myProgressText;
    }

    public JLabel getCancelProgressButton() {
        return this.myCancelProgressButton;
    }

    @NotNull
    private static Validator.Result validateFlutterSdk(String sdkPath) {
        if (!sdkPath.isEmpty()) {
            String message = FlutterSdkUtil.getErrorMessageIfWrongSdkRootPath((String)sdkPath);
            if (message != null) {
                Validator.Result result = Validator.Result.fromNullableMessage((String)message);
                if (result == null) {
                    FlutterProjectStep.$$$reportNull$$$0(15);
                }
                return result;
            }
            Validator.Result result = Validator.Result.OK;
            if (result == null) {
                FlutterProjectStep.$$$reportNull$$$0(16);
            }
            return result;
        }
        Validator.Result result = Validator.Result.fromNullableMessage((String)"Flutter SDK path not given.");
        if (result == null) {
            FlutterProjectStep.$$$reportNull$$$0(17);
        }
        return result;
    }

    @NotNull
    private static String findProjectLocation(@NotNull String appName) {
        if (appName == null) {
            FlutterProjectStep.$$$reportNull$$$0(18);
        }
        String string = WizardUtils.getProjectLocationParent().getPath();
        if (string == null) {
            FlutterProjectStep.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static Validator.Result errorResult(String message) {
        return new Validator.Result(Validator.Severity.ERROR, message);
    }

    public static void ensureComboModelContainsCurrentItem(@NotNull JComboBox comboBox) {
        if (comboBox == null) {
            FlutterProjectStep.$$$reportNull$$$0(20);
        }
        Object currentItem = comboBox.getEditor().getItem();
        boolean contains = false;
        for (int i = 0; i < comboBox.getModel().getSize(); ++i) {
            if (!currentItem.equals(comboBox.getModel().getElementAt(i))) continue;
            contains = true;
            break;
        }
        if (!contains) {
            ((DefaultComboBoxModel)comboBox.getModel()).insertElementAt(currentItem, 0);
        }
        comboBox.setSelectedItem(currentItem);
        comboBox.getEditor().setItem(currentItem);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        FlutterCreateParams flutterCreateParams;
        JTextPane jTextPane;
        JLabel jLabel;
        JProgressBar jProgressBar;
        LinkLabel linkLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JLabel jLabel2;
        JTextField jTextField;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JTextField jTextField2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(13, 2, new Insets(0, 5, 0, 5), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        Font font = jLabel3.getFont();
        if (font != null) {
            jLabel3.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        jLabel3.setText("Project name");
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        Font font2 = jLabel4.getFont();
        if (font2 != null) {
            jLabel4.setFont(new Font(font2.getName(), 1, font2.getSize()));
        }
        jLabel4.setText("Flutter SDK path");
        jPanel2.add((Component)jLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        Font font3 = jLabel5.getFont();
        if (font3 != null) {
            jLabel5.setFont(new Font(font3.getName(), 1, font3.getSize()));
        }
        jLabel5.setText("Description");
        jPanel2.add((Component)jLabel5, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectName = jTextField2 = new JTextField();
        jTextField2.setToolTipText("The name that will be shown in the launcher for this application");
        jPanel2.add((Component)jTextField2, new GridConstraints(3, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myFlutterSdkPath = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(6, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDescription = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(10, 0, 1, 2, 8, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        this.myHeading = jLabel2 = new JLabel();
        Font font4 = jLabel2.getFont();
        if (font4 != null) {
            jLabel2.setFont(new Font(font4.getName(), 1, 20));
        }
        jLabel2.setText("heading");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        this.myLocationPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myProjectLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        Font font5 = jLabel6.getFont();
        if (font5 != null) {
            jLabel6.setFont(new Font(font5.getName(), 1, font5.getSize()));
        }
        jLabel6.setText("Project location");
        jPanel.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        this.myInstallActionLink = linkLabel = new LinkLabel();
        linkLabel.setText("Install SDK");
        jPanel2.add((Component)linkLabel, new GridConstraints(6, 1, 1, 1, 4, 0, 1, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(12, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jPanel3.add((Component)jProgressBar, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel3.add((Component)spacer5, new GridConstraints(2, 1, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myCancelProgressButton = jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/cancel.png")));
        jLabel.setText("");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel3.add((Component)spacer6, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel3.add((Component)spacer7, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerifyInputWhenFocusTarget(true);
        ((Component)jScrollPane).setVisible(true);
        jPanel3.add((Component)jScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myProgressText = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        Font font6 = jTextPane.getFont();
        if (font6 != null) {
            jTextPane.setFont(new Font(font6.getName(), 2, font6.getSize()));
        }
        jTextPane.setMinimumSize(new Dimension(71, 32));
        jTextPane.setPreferredSize(new Dimension(170, 32));
        ((Component)jTextPane).setVisible(true);
        jScrollPane.setViewportView(jTextPane);
        this.myCreateParams = flutterCreateParams = new FlutterCreateParams();
        JComponent jComponent = flutterCreateParams.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(11, 0, 1, 2, 1, 1, 6, 2, null, null, null));
        jLabel3.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/project/FlutterProjectStep";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/project/FlutterProjectStep";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "validateFlutterModuleName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "validateFlutterSdk";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findProjectLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "validateFlutterModuleName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findProjectLocation";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "ensureComboModelContainsCurrentItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

