/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.android.repository.io.FileOpUtils;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionService;
import com.intellij.execution.OutputListener;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.PlatformProjectOpenProcessor;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.module.FlutterModuleBuilder;
import io.flutter.module.FlutterProjectType;
import io.flutter.project.FlutterProjectModel;
import io.flutter.pub.PubRoot;
import io.flutter.sdk.FlutterCreateAdditionalSettings;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.FlutterModuleUtils;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class FlutterProjectCreator {
    private static final Logger LOG = Logger.getInstance(FlutterProjectCreator.class);
    private static final String SEPARATOR = "/";
    @NotNull
    private final FlutterProjectModel myModel;

    public FlutterProjectCreator(@NotNull FlutterProjectModel model) {
        if (model == null) {
            FlutterProjectCreator.$$$reportNull$$$0(0);
        }
        this.myModel = model;
    }

    public void createModule() {
        Project project = (Project)this.myModel.project().getValue();
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return;
        }
        String baseDirPath = baseDir.getPath();
        String moduleName = ProjectWizardUtil.findNonExistingFileName((String)baseDirPath, (String)((String)this.myModel.projectName().get()), (String)"");
        String contentRoot = baseDirPath + SEPARATOR + moduleName;
        File location = new File(contentRoot);
        if (!location.exists() && !location.mkdirs()) {
            String message = ActionsBundle.message((String)"action.NewDirectoryProject.cannot.create.dir", (Object[])new Object[]{location.getAbsolutePath()});
            Messages.showErrorDialog((Project)project, (String)message, (String)ActionsBundle.message((String)"action.NewDirectoryProject.title", (Object[])new Object[0]));
            return;
        }
        FlutterModuleBuilder builder = new FlutterModuleBuilder(){

            @NotNull
            public FlutterCreateAdditionalSettings getAdditionalSettings() {
                FlutterCreateAdditionalSettings flutterCreateAdditionalSettings = FlutterProjectCreator.this.makeAdditionalSettings();
                if (flutterCreateAdditionalSettings == null) {
                    1.$$$reportNull$$$0(0);
                }
                return flutterCreateAdditionalSettings;
            }

            protected FlutterSdk getFlutterSdk() {
                return FlutterSdk.forPath((String)((String)FlutterProjectCreator.this.myModel.flutterSdk().get()));
            }

            public boolean validate(Project current, Project dest) {
                return true;
            }

            public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
                return null;
            }

            public void setFlutterSdkPath(String s) {
            }

            public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
                if (settingsStep == null) {
                    1.$$$reportNull$$$0(1);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "io/flutter/project/FlutterProjectCreator$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settingsStep";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAdditionalSettings";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "io/flutter/project/FlutterProjectCreator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "modifySettingsStep";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        builder.setName((String)this.myModel.projectName().get());
        builder.setModuleFilePath(FileUtilRt.toSystemIndependentName((String)contentRoot) + SEPARATOR + moduleName + ".iml");
        builder.commitModule(project, null);
    }

    public void createProject() {
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        Project projectToClose = frame != null ? frame.getProject() : null;
        File location = new File(FileUtil.toSystemDependentName((String)((String)this.myModel.projectLocation().get())));
        if (!location.exists() && !location.mkdirs()) {
            String message = ActionsBundle.message((String)"action.NewDirectoryProject.cannot.create.dir", (Object[])new Object[]{location.getAbsolutePath()});
            Messages.showErrorDialog((Project)projectToClose, (String)message, (String)ActionsBundle.message((String)"action.NewDirectoryProject.title", (Object[])new Object[0]));
            return;
        }
        File baseFile = new File(location, (String)this.myModel.projectName().get());
        baseFile.mkdirs();
        VirtualFile baseDir = (VirtualFile)ApplicationManager.getApplication().runWriteAction(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(baseFile));
        if (baseDir == null) {
            FlutterUtils.warn((Logger)LOG, (String)("Couldn't find '" + location + "' in VFS"));
            return;
        }
        ConversionService.getInstance().convertSilently(baseDir.getPath(), (ConversionListener)new MyConversionListener());
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(location.getPath());
        FlutterSdk sdk = FlutterSdk.forPath((String)((String)this.myModel.flutterSdk().get()));
        if (sdk == null) {
            FlutterMessages.showError((String)"Error creating project", (String)((String)this.myModel.flutterSdk().get() + " is not a valid Flutter SDK"));
            return;
        }
        OutputListener listener = new OutputListener();
        ProgressManager progress = ProgressManager.getInstance();
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        progress.runProcessWithProgressSynchronously(() -> {
            progress.getProgressIndicator().setIndeterminate(true);
            sdk.createFiles(baseDir, null, (ProcessListener)listener, this.makeAdditionalSettings());
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
            result.set(PubRoot.forDirectory((VirtualFile)baseDir));
        }, "Creating Flutter Project", false, null);
        PubRoot root = result.get();
        if (root == null) {
            String stderr = listener.getOutput().getStderr();
            FlutterMessages.showError((String)"Error creating project", (String)(stderr.isEmpty() ? "Flutter create command was unsuccessful" : stderr));
            return;
        }
        EnumSet<PlatformProjectOpenProcessor.Option> options = EnumSet.noneOf(PlatformProjectOpenProcessor.Option.class);
        Project project = PlatformProjectOpenProcessor.doOpenProject((VirtualFile)baseDir, (Project)projectToClose, (int)-1, null, options);
        if (project != null) {
            FlutterUtils.disableGradleProjectMigrationNotification((Project)project);
            FlutterProjectCreator.disableUserConfig(project);
            StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> ApplicationManager.getApplication().invokeLater(() -> DumbService.getInstance((Project)project).runWhenSmart(() -> {
                ProjectView.getInstance((Project)project).changeView("ProjectPane");
                ProjectUtil.focusProjectWindow((Project)project, (boolean)true);
            }), ModalityState.defaultModalityState()));
        }
    }

    private FlutterCreateAdditionalSettings makeAdditionalSettings() {
        return new FlutterCreateAdditionalSettings.Builder().setDescription(((String)this.myModel.description().get()).isEmpty() ? null : (String)this.myModel.description().get()).setType((FlutterProjectType)this.myModel.projectType().getValue()).setOrg(((String)this.myModel.packageName().get()).isEmpty() ? null : FlutterProjectCreator.reversedOrgFromPackage((String)this.myModel.packageName().get())).setKotlin(this.isNotModule() && this.myModel.useKotlin().get() != false ? Boolean.valueOf(true) : null).setSwift(this.isNotModule() && this.myModel.useSwift().get() != false ? Boolean.valueOf(true) : null).setOffline(this.myModel.isOfflineSelected().get()).build();
    }

    private boolean isNotModule() {
        return !this.myModel.isModule();
    }

    public static void disableUserConfig(Project project) {
        if (FlutterModuleUtils.declaresFlutter((Project)project)) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                AndroidFacet facet = AndroidFacet.getInstance((Module)module);
                if (facet == null) continue;
                facet.getProperties().ALLOW_USER_CONFIGURATION = false;
            }
        }
    }

    public static boolean finalValidityCheckPassed(@NotNull String projectLocation) {
        boolean couldEnsureLocationExists;
        if (projectLocation == null) {
            FlutterProjectCreator.$$$reportNull$$$0(1);
        }
        if (!(couldEnsureLocationExists = ((Boolean)WriteCommandAction.runWriteCommandAction(null, () -> {
            try {
                if (VfsUtil.createDirectoryIfMissing((String)projectLocation) != null && FileOpUtils.create().canWrite(new File(projectLocation))) {
                    return true;
                }
            }
            catch (Exception e) {
                LOG.warn(String.format("Exception thrown when creating target project location: %1$s", projectLocation), (Throwable)e);
            }
            return false;
        })).booleanValue())) {
            String msg = "Could not ensure the target project location exists and is accessible:\n\n%1$s\n\nPlease try to specify another path.";
            Messages.showErrorDialog((String)String.format(msg, projectLocation), (String)"Error Creating Project");
            return false;
        }
        return true;
    }

    private static String reversedOrgFromPackage(@NotNull String packageName) {
        int idx;
        if (packageName == null) {
            FlutterProjectCreator.$$$reportNull$$$0(2);
        }
        if ((idx = packageName.lastIndexOf(46)) <= 0) {
            return packageName;
        }
        return packageName.substring(0, idx);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLocation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        objectArray2[1] = "io/flutter/project/FlutterProjectCreator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "finalValidityCheckPassed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reversedOrgFromPackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyConversionListener
    implements ConversionListener {
        private boolean myConversionNeeded;
        private boolean myConverted;

        public void conversionNeeded() {
            this.myConversionNeeded = true;
        }

        public void successfullyConverted(File backupDir) {
            this.myConverted = true;
        }

        public void error(String message) {
        }

        public void cannotWriteToFiles(List<? extends File> readonlyFiles) {
        }

        public boolean isConversionNeeded() {
            return this.myConversionNeeded;
        }

        public boolean isConverted() {
            return this.myConverted;
        }
    }
}

