/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class FlutterCreateState {
    private static final Logger LOG = Logger.getInstance(FlutterCreateState.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myLock;
    private boolean myCreateInProgress;

    public FlutterCreateState(@NotNull Project project) {
        if (project == null) {
            FlutterCreateState.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myProject = project;
    }

    @NotNull
    public static FlutterCreateState getInstance(@NotNull Project project) {
        if (project == null) {
            FlutterCreateState.$$$reportNull$$$0(1);
        }
        FlutterCreateState flutterCreateState = (FlutterCreateState)ServiceManager.getService((Project)project, FlutterCreateState.class);
        if (flutterCreateState == null) {
            FlutterCreateState.$$$reportNull$$$0(2);
        }
        return flutterCreateState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createStarted() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCreateInProgress) {
                LOG.info(String.format("flutter create already in progress for project '%1$s'.", this.myProject.getName()));
                return false;
            }
            this.myCreateInProgress = true;
            return true;
        }
    }

    public void createEnded() {
        this.stopCreateInProgress();
    }

    public void createFailed(String message) {
        String msg = "flutter create failed";
        if (StringUtil.isNotEmpty((String)message)) {
            msg = msg + String.format(": %1$s", message);
        }
        LOG.info(msg);
        this.stopCreateInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCreateInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCreateInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopCreateInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            this.myCreateInProgress = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/project/FlutterCreateState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/project/FlutterCreateState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

