/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.android.tools.adtui.ASGallery;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.HashMap;
import io.flutter.module.FlutterDescriptionProvider;
import io.flutter.project.FlutterProjectModel;
import io.flutter.project.FlutterProjectStep;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChoseProjectTypeStep
extends ModelWizardStep<FlutterProjectModel> {
    private static final Logger LOG = Logger.getInstance(ChoseProjectTypeStep.class);
    private final List<FlutterDescriptionProvider.FlutterGalleryEntry> myModuleGalleryEntryList;
    private final JComponent myRootPanel;
    private JLabel[] helpLabels;
    private ASGallery<ModuleGalleryEntry> myProjectTypeGallery;
    private Map<ModuleGalleryEntry, FlutterProjectStep> myModuleDescriptionToStepMap;

    public ChoseProjectTypeStep(@NotNull FlutterProjectModel model) {
        if (model == null) {
            ChoseProjectTypeStep.$$$reportNull$$$0(0);
        }
        this(model, FlutterDescriptionProvider.getGalleryList(true));
    }

    private ChoseProjectTypeStep(@NotNull FlutterProjectModel model, @NotNull List<FlutterDescriptionProvider.FlutterGalleryEntry> moduleGalleryEntries) {
        if (model == null) {
            ChoseProjectTypeStep.$$$reportNull$$$0(1);
        }
        if (moduleGalleryEntries == null) {
            ChoseProjectTypeStep.$$$reportNull$$$0(2);
        }
        super((WizardModel)model, "New Flutter Project");
        this.myModuleGalleryEntryList = moduleGalleryEntries;
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new VerticalFlowLayout());
        this.myRootPanel.add(this.createGallery());
        JPanel section = new JPanel();
        section.setLayout((LayoutManager)new VerticalFlowLayout());
        this.helpLabels = new JLabel[moduleGalleryEntries.size()];
        int idx = 0;
        for (FlutterDescriptionProvider.FlutterGalleryEntry entry : moduleGalleryEntries) {
            this.helpLabels[idx] = new JLabel(entry.getHelpText());
            this.helpLabels[idx].setEnabled(false);
            section.add(this.helpLabels[idx++]);
        }
        this.myProjectTypeGallery.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.toggleLabel(e.getFirstIndex());
            this.toggleLabel(e.getLastIndex());
        });
        this.toggleLabel(0);
        this.myRootPanel.add(section);
        FormScalingUtil.scaleComponentTree(((Object)((Object)this)).getClass(), (JComponent)this.myRootPanel);
    }

    private void toggleLabel(int index) {
        this.helpLabels[index].setEnabled(!this.helpLabels[index].isEnabled());
    }

    @NotNull
    protected JComponent getComponent() {
        JComponent jComponent = this.myRootPanel;
        if (jComponent == null) {
            ChoseProjectTypeStep.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    public Collection<? extends ModelWizardStep> createDependentSteps() {
        ArrayList allSteps = Lists.newArrayList();
        this.myModuleDescriptionToStepMap = new HashMap();
        for (ModuleGalleryEntry moduleGalleryEntry : this.myModuleGalleryEntryList) {
            FlutterProjectStep step = ((FlutterDescriptionProvider.FlutterGalleryEntry)moduleGalleryEntry).createFlutterStep((FlutterProjectModel)this.getModel());
            allSteps.add(step);
            this.myModuleDescriptionToStepMap.put(moduleGalleryEntry, step);
        }
        ArrayList arrayList = allSteps;
        if (arrayList == null) {
            ChoseProjectTypeStep.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private JComponent createGallery() {
        this.myProjectTypeGallery = new ASGallery<ModuleGalleryEntry>((ListModel)JBList.createDefaultListModel((Object[])new Object[0]), image -> image == null ? null : (image.getIcon() == null ? null : image.getIcon()), label -> label == null ? AndroidBundle.message((String)"android.wizard.gallery.item.none", (Object[])new Object[0]) : label.getName(), WizardConstants.DEFAULT_GALLERY_THUMBNAIL_SIZE, null){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension cellSize = this.computeCellSize();
                int heightInsets = this.getInsets().top + this.getInsets().bottom;
                int widthInsets = this.getInsets().left + this.getInsets().right;
                return new Dimension(cellSize.width * 5 + widthInsets, (int)((double)cellSize.height * 1.2) + heightInsets);
            }
        };
        this.myProjectTypeGallery.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        AccessibleContext accessibleContext = this.myProjectTypeGallery.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleDescription(this.getTitle());
        }
        JBScrollPane jBScrollPane = new JBScrollPane(this.myProjectTypeGallery);
        if (jBScrollPane == null) {
            ChoseProjectTypeStep.$$$reportNull$$$0(5);
        }
        return jBScrollPane;
    }

    protected void onWizardStarting(final @NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ChoseProjectTypeStep.$$$reportNull$$$0(6);
        }
        this.myProjectTypeGallery.setModel((ListModel)JBList.createDefaultListModel((Object[])this.myModuleGalleryEntryList.toArray()));
        this.myProjectTypeGallery.setDefaultAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                wizard.goForward();
            }
        });
        this.myProjectTypeGallery.setSelectedIndex(0);
    }

    protected void onProceeding() {
        ModuleGalleryEntry selectedEntry = (ModuleGalleryEntry)this.myProjectTypeGallery.getSelectedElement();
        this.myModuleDescriptionToStepMap.forEach((galleryEntry, step) -> step.setShouldShow(galleryEntry == selectedEntry));
    }

    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myProjectTypeGallery;
    }

    @NotNull
    private static List<ModuleGalleryEntry> getGalleryList() {
        ArrayList<ModuleGalleryEntry> arrayList = new ArrayList<ModuleGalleryEntry>();
        if (arrayList == null) {
            ChoseProjectTypeStep.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGalleryEntries";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/project/ChoseProjectTypeStep";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/project/ChoseProjectTypeStep";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createGallery";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGalleryList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

