/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.module;

import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import io.flutter.FlutterBundle;
import io.flutter.module.FlutterProjectType;
import io.flutter.project.FlutterProjectModel;
import io.flutter.pub.PubRoot;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportFlutterModuleStep
extends SkippableWizardStep<FlutterProjectModel> {
    private static String DIRECTORY_NOUN = SystemInfo.isMac ? "folder" : "directory";
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final StudioWizardStepPanel myRootPanel;
    private TextFieldWithBrowseButton myFlutterModuleLocationField;
    private JPanel myPanel;

    public ImportFlutterModuleStep(FlutterProjectModel model, String title, Icon icon, FlutterProjectType type) {
        super((WizardModel)model, title, icon);
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        String initialLocation = WizardUtils.getProjectLocationParent().getPath();
        ((JTextField)this.myFlutterModuleLocationField.getChildComponent()).setText(initialLocation);
        TextProperty locationText = new TextProperty((JTextComponent)this.myFlutterModuleLocationField.getChildComponent());
        this.myBindings.bind((SettableValue)model.projectLocation(), (ObservableValue)locationText);
        this.myFlutterModuleLocationField.addBrowseFolderListener(FlutterBundle.message((String)"flutter.module.import.settings.location.select", (Object[])new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myValidatorPanel.registerValidator((ObservableValue)model.projectLocation(), ImportFlutterModuleStep::validateFlutterModuleLocation);
        this.myRootPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel);
        FormScalingUtil.scaleComponentTree(((Object)((Object)this)).getClass(), (JComponent)this.myRootPanel);
    }

    public void dispose() {
        this.myBindings.releaseAll();
    }

    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myRootPanel;
        if (studioWizardStepPanel == null) {
            ImportFlutterModuleStep.$$$reportNull$$$0(0);
        }
        return studioWizardStepPanel;
    }

    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myFlutterModuleLocationField.getTextField();
    }

    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            ImportFlutterModuleStep.$$$reportNull$$$0(1);
        }
        return observableBool;
    }

    @NotNull
    private static Validator.Result validateFlutterModuleLocation(String path) {
        VirtualFile file = VfsUtil.findFileByIoFile((File)new File(path), (boolean)true);
        if (file == null) {
            Validator.Result result = Validator.Result.fromNullableMessage((String)"File not found");
            if (result == null) {
                ImportFlutterModuleStep.$$$reportNull$$$0(2);
            }
            return result;
        }
        if (!file.isDirectory()) {
            Validator.Result result = Validator.Result.fromNullableMessage((String)("Please select a " + DIRECTORY_NOUN + " containing a Flutter module"));
            if (result == null) {
                ImportFlutterModuleStep.$$$reportNull$$$0(3);
            }
            return result;
        }
        PubRoot root = PubRoot.forDirectory((VirtualFile)file);
        if (root == null || !root.isFlutterModule()) {
            Validator.Result result = Validator.Result.fromNullableMessage((String)("The selected " + DIRECTORY_NOUN + " is not a Flutter module"));
            if (result == null) {
                ImportFlutterModuleStep.$$$reportNull$$$0(4);
            }
            return result;
        }
        Validator.Result result = Validator.Result.OK;
        if (result == null) {
            ImportFlutterModuleStep.$$$reportNull$$$0(5);
        }
        return result;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("module.wizard.import_module_step_body"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myFlutterModuleLocationField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(500, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "io/flutter/module/ImportFlutterModuleStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "validateFlutterModuleLocation";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

