/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.module;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.module.FlutterModuleModel;
import io.flutter.utils.System;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.Nullable;

public class FlutterModuleImporter {
    private static String EDIT_INSTR_LINK = "https://github.com/flutter/flutter/wiki/Add-Flutter-to-existing-apps#make-the-host-app-depend-on-the-flutter-module";
    private final FlutterModuleModel myModel;
    private boolean hasFinishedEditing = false;
    private StringWriter writer;
    private String myRelativePath;
    private String myNewline;

    public FlutterModuleImporter(FlutterModuleModel model) {
        this.myModel = model;
        this.myNewline = java.lang.System.lineSeparator();
    }

    public void importModule() {
        StringWriter buildWriter;
        StringWriter settingsWriter;
        String location = (String)this.myModel.projectLocation().get();
        VirtualFile moduleRoot = VfsUtil.findFileByIoFile((File)new File(location), (boolean)true);
        assert (moduleRoot != null);
        assert (((Optional)this.myModel.project().get()).isPresent());
        Project androidProject = (Project)((Optional)this.myModel.project().get()).get();
        VirtualFile projectRoot = androidProject.getBaseDir();
        this.myRelativePath = System.findRelativePath((VirtualFile)projectRoot.getParent(), (VirtualFile)moduleRoot, (char)File.separatorChar);
        if (this.myRelativePath == null) {
            FlutterModuleImporter.showHowToEditDialog();
            return;
        }
        String newPath = Paths.get(this.myRelativePath, ".android", "include_flutter.groovy").normalize().toString();
        if (!new File(moduleRoot.getParent().getPath(), newPath).exists()) {
            FlutterModuleImporter.showHowToEditDialog();
            return;
        }
        this.myRelativePath = StringUtil.escapeBackSlashes((String)newPath);
        VirtualFile settingsFile = projectRoot.findChild("settings.gradle");
        if (settingsFile == null) {
            FlutterModuleImporter.showHowToEditDialog();
            return;
        }
        VirtualFile appDir = projectRoot.findChild("app");
        if (appDir == null) {
            FlutterModuleImporter.showHowToEditDialog();
            return;
        }
        VirtualFile buildFile = appDir.findChild("build.gradle");
        if (buildFile == null) {
            FlutterModuleImporter.showHowToEditDialog();
            return;
        }
        this.writer = new StringWriter();
        try {
            settingsWriter = this.editFileContent(settingsFile, this::writeSettingsLineWithEdits);
            buildWriter = this.editFileContent(buildFile, this::writeBuildLineWithEdits);
        }
        catch (IOException e) {
            FlutterModuleImporter.showHowToEditDialog();
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                settingsFile.setBinaryContent(settingsWriter.toString().getBytes(Charset.defaultCharset()));
                buildFile.setBinaryContent(buildWriter.toString().getBytes(Charset.defaultCharset()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private StringWriter editFileContent(VirtualFile file, Consumer<String> editFunction) throws IOException {
        this.writer = new StringWriter();
        try (BufferedReader r = Files.newBufferedReader(Paths.get(file.getPath(), new String[0]), Charset.defaultCharset());){
            this.hasFinishedEditing = false;
            r.lines().forEach(editFunction);
            this.writer.close();
        }
        return this.writer;
    }

    private void writeSettingsLineWithEdits(String line) {
        this.writeLineWithEdits(line, "include", this::writeSettingsModToBuffer);
    }

    private void writeBuildLineWithEdits(String line) {
        this.writeLineWithEdits(line, "dependencies", this::writeBuildModToBuffer);
    }

    private void writeLineWithEdits(String line, String trigger, Supplier editFunction) {
        if (this.hasFinishedEditing) {
            this.writeLineToBuffer(line);
        } else if (line.trim().startsWith(trigger)) {
            this.writeLineToBuffer(line);
            this.hasFinishedEditing = (Boolean)editFunction.get();
        } else {
            this.writeLineToBuffer(line);
        }
    }

    private boolean writeSettingsModToBuffer() {
        this.writeLineToBuffer("setBinding(new Binding([gradle: this]))");
        this.writeLineToBuffer("evaluate(new File(");
        this.writeLineToBuffer("  settingsDir.parentFile,");
        this.writeLineToBuffer("  '" + this.myRelativePath + "'");
        this.writeLineToBuffer("))");
        return true;
    }

    private boolean writeBuildModToBuffer() {
        this.writeLineToBuffer("    implementation project(':flutter')");
        return true;
    }

    private void writeLineToBuffer(String line) {
        this.writer.write(line);
        this.writer.write(this.myNewline);
    }

    private static void showHowToEditDialog() {
        ApplicationManager.getApplication().invokeLater(() -> new HowToEditDialog().show(), ModalityState.NON_MODAL);
    }

    private static class HowToEditDialog
    extends DialogWrapper {
        private JPanel myPanel;
        private JTextPane myTextPane;

        HowToEditDialog() {
            super(null, false, false);
            this.setTitle("Automatic Import Failed");
            this.myPanel = new JPanel();
            this.myTextPane = new JTextPane();
            Messages.installHyperlinkSupport((JTextPane)this.myTextPane);
            String howToEdit = "<html><body><p>The Gradle files could not be updated automatically.<p>To use your Flutter module in this Android app you'll need to<br>edit the files as described in the <a href=\"" + EDIT_INSTR_LINK + "\">add2app documentation.</a></body></html>";
            this.myTextPane.setText(howToEdit);
            this.myPanel.add(this.myTextPane);
            this.init();
            this.getButton(this.getCancelAction()).setVisible(false);
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myPanel;
        }
    }
}

