/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.module;

import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.IconUtil;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.module.FlutterModuleModel;
import io.flutter.module.FlutterModuleStep;
import io.flutter.module.FlutterProjectType;
import io.flutter.module.ImportFlutterModuleStep;
import io.flutter.project.FlutterProjectModel;
import io.flutter.project.FlutterProjectStep;
import io.flutter.utils.FlutterModuleUtils;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterDescriptionProvider
implements ModuleDescriptionProvider {
    public Collection<? extends ModuleGalleryEntry> getDescriptions() {
        return FlutterDescriptionProvider.getGalleryList(false);
    }

    public Collection<? extends ModuleGalleryEntry> getDescriptions(Project project) {
        return FlutterDescriptionProvider.getGalleryList(false);
    }

    public static List<FlutterGalleryEntry> getGalleryList(boolean isNewProject) {
        boolean projectHasFlutter = isNewProject;
        OptionalValueProperty sharedModel = new OptionalValueProperty();
        ArrayList<FlutterGalleryEntry> res = new ArrayList<FlutterGalleryEntry>();
        if (!isNewProject) {
            Project project;
            IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            Project project2 = project = frame == null ? null : frame.getProject();
            if (project == null) {
                return res;
            }
            for (Module module : FlutterModuleUtils.getModules((Project)project)) {
                if (!FlutterModuleUtils.isFlutterModule((Module)module)) continue;
                projectHasFlutter = true;
                break;
            }
        }
        if (projectHasFlutter) {
            if (isNewProject) {
                res.add(new FlutterApplicationGalleryEntry(sharedModel));
            }
            res.add(new FlutterPluginGalleryEntry(sharedModel));
            res.add(new FlutterPackageGalleryEntry(sharedModel));
            if (isNewProject) {
                res.add(new FlutterModuleGalleryEntry(sharedModel));
            }
        } else {
            res.add(new ImportFlutterModuleGalleryEntry(sharedModel));
        }
        return res;
    }

    private static class ImportFlutterModuleGalleryEntry
    extends FlutterGalleryEntry {
        private ImportFlutterModuleGalleryEntry(OptionalValueProperty<FlutterProjectModel> sharedModel) {
            super(sharedModel);
        }

        @Nullable
        public Image getIcon() {
            return IconUtil.toImage((Icon)FlutterIcons.AndroidStudioNewModule);
        }

        @NotNull
        public String getName() {
            String string = FlutterBundle.message((String)"module.wizard.import_module_title", (Object[])new Object[0]);
            if (string == null) {
                ImportFlutterModuleGalleryEntry.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public String getDescription() {
            return FlutterBundle.message((String)"module.wizard.import_module_description", (Object[])new Object[0]);
        }

        @Override
        @Nullable
        public String getHelpText() {
            return FlutterBundle.message((String)"flutter.module.import.settings.help.description", (Object[])new Object[0]);
        }

        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            if (model == null) {
                ImportFlutterModuleGalleryEntry.$$$reportNull$$$0(1);
            }
            ImportFlutterModuleStep importFlutterModuleStep = new ImportFlutterModuleStep(this.model(model, FlutterProjectType.IMPORT), FlutterBundle.message((String)"module.wizard.import_module_step_title", (Object[])new Object[0]), FlutterIcons.Flutter_64, FlutterProjectType.IMPORT);
            if (importFlutterModuleStep == null) {
                ImportFlutterModuleGalleryEntry.$$$reportNull$$$0(2);
            }
            return importFlutterModuleStep;
        }

        @Override
        @NotNull
        public FlutterProjectStep createFlutterStep(@NotNull FlutterProjectModel model) {
            if (model == null) {
                ImportFlutterModuleGalleryEntry.$$$reportNull$$$0(3);
            }
            FlutterProjectStep flutterProjectStep = new FlutterProjectStep(model, FlutterBundle.message((String)"module.wizard.import_module_step_title", (Object[])new Object[0]), FlutterIcons.Flutter_64, FlutterProjectType.IMPORT);
            if (flutterProjectStep == null) {
                ImportFlutterModuleGalleryEntry.$$$reportNull$$$0(4);
            }
            return flutterProjectStep;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/module/FlutterDescriptionProvider$ImportFlutterModuleGalleryEntry";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/module/FlutterDescriptionProvider$ImportFlutterModuleGalleryEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStep";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFlutterStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createFlutterStep";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FlutterModuleGalleryEntry
    extends FlutterGalleryEntry {
        private FlutterModuleGalleryEntry(OptionalValueProperty<FlutterProjectModel> sharedModel) {
            super(sharedModel);
        }

        @Nullable
        public Image getIcon() {
            return IconUtil.toImage((Icon)FlutterIcons.AndroidStudioNewModule);
        }

        @NotNull
        public String getName() {
            String string = FlutterBundle.message((String)"module.wizard.module_title", (Object[])new Object[0]);
            if (string == null) {
                FlutterModuleGalleryEntry.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public String getDescription() {
            return FlutterBundle.message((String)"module.wizard.module_description", (Object[])new Object[0]);
        }

        @Override
        @Nullable
        public String getHelpText() {
            return FlutterBundle.message((String)"flutter.module.create.settings.help.project_type.description.module", (Object[])new Object[0]);
        }

        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            if (model == null) {
                FlutterModuleGalleryEntry.$$$reportNull$$$0(1);
            }
            FlutterModuleStep flutterModuleStep = new FlutterModuleStep(this.model(model, FlutterProjectType.MODULE), FlutterBundle.message((String)"module.wizard.module_step_title", (Object[])new Object[0]), FlutterIcons.Flutter_64, FlutterProjectType.MODULE);
            if (flutterModuleStep == null) {
                FlutterModuleGalleryEntry.$$$reportNull$$$0(2);
            }
            return flutterModuleStep;
        }

        @Override
        @NotNull
        public FlutterProjectStep createFlutterStep(@NotNull FlutterProjectModel model) {
            if (model == null) {
                FlutterModuleGalleryEntry.$$$reportNull$$$0(3);
            }
            FlutterProjectStep flutterProjectStep = new FlutterProjectStep(model, FlutterBundle.message((String)"module.wizard.module_step_title", (Object[])new Object[0]), FlutterIcons.Flutter_64, FlutterProjectType.MODULE);
            if (flutterProjectStep == null) {
                FlutterModuleGalleryEntry.$$$reportNull$$$0(4);
            }
            return flutterProjectStep;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/module/FlutterDescriptionProvider$FlutterModuleGalleryEntry";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/module/FlutterDescriptionProvider$FlutterModuleGalleryEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStep";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFlutterStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createFlutterStep";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FlutterPluginGalleryEntry
    extends FlutterGalleryEntry {
        private FlutterPluginGalleryEntry(OptionalValueProperty<FlutterProjectModel> sharedModel) {
            super(sharedModel);
        }

        @Nullable
        public Image getIcon() {
            return IconUtil.toImage((Icon)FlutterIcons.AndroidStudioNewPlugin);
        }

        @NotNull
        public String getName() {
            String string = FlutterBundle.message((String)"module.wizard.plugin_title", (Object[])new Object[0]);
            if (string == null) {
                FlutterPluginGalleryEntry.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public String getDescription() {
            return FlutterBundle.message((String)"module.wizard.plugin_description", (Object[])new Object[0]);
        }

        @Override
        @Nullable
        public String getHelpText() {
            return FlutterBundle.message((String)"flutter.module.create.settings.help.project_type.description.plugin", (Object[])new Object[0]);
        }

        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            if (model == null) {
                FlutterPluginGalleryEntry.$$$reportNull$$$0(1);
            }
            FlutterModuleStep flutterModuleStep = new FlutterModuleStep(this.model(model, FlutterProjectType.PLUGIN), FlutterBundle.message((String)"module.wizard.plugin_step_title", (Object[])new Object[0]), FlutterIcons.Flutter_64, FlutterProjectType.PLUGIN);
            if (flutterModuleStep == null) {
                FlutterPluginGalleryEntry.$$$reportNull$$$0(2);
            }
            return flutterModuleStep;
        }

        @Override
        @NotNull
        public FlutterProjectStep createFlutterStep(@NotNull FlutterProjectModel model) {
            if (model == null) {
                FlutterPluginGalleryEntry.$$$reportNull$$$0(3);
            }
            FlutterProjectStep flutterProjectStep = new FlutterProjectStep(model, FlutterBundle.message((String)"module.wizard.plugin_step_title", (Object[])new Object[0]), FlutterIcons.Flutter_64, FlutterProjectType.PLUGIN);
            if (flutterProjectStep == null) {
                FlutterPluginGalleryEntry.$$$reportNull$$$0(4);
            }
            return flutterProjectStep;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/module/FlutterDescriptionProvider$FlutterPluginGalleryEntry";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/module/FlutterDescriptionProvider$FlutterPluginGalleryEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStep";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFlutterStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createFlutterStep";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FlutterPackageGalleryEntry
    extends FlutterGalleryEntry {
        private FlutterPackageGalleryEntry(OptionalValueProperty<FlutterProjectModel> sharedModel) {
            super(sharedModel);
        }

        @Nullable
        public Image getIcon() {
            return IconUtil.toImage((Icon)FlutterIcons.AndroidStudioNewPackage);
        }

        @NotNull
        public String getName() {
            String string = FlutterBundle.message((String)"module.wizard.package_title", (Object[])new Object[0]);
            if (string == null) {
                FlutterPackageGalleryEntry.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public String getDescription() {
            return FlutterBundle.message((String)"module.wizard.package_description", (Object[])new Object[0]);
        }

        @Override
        @Nullable
        public String getHelpText() {
            return FlutterBundle.message((String)"flutter.module.create.settings.help.project_type.description.package", (Object[])new Object[0]);
        }

        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            if (model == null) {
                FlutterPackageGalleryEntry.$$$reportNull$$$0(1);
            }
            FlutterModuleStep flutterModuleStep = new FlutterModuleStep(this.model(model, FlutterProjectType.PACKAGE), FlutterBundle.message((String)"module.wizard.package_step_title", (Object[])new Object[0]), FlutterIcons.Flutter_64, FlutterProjectType.PACKAGE);
            if (flutterModuleStep == null) {
                FlutterPackageGalleryEntry.$$$reportNull$$$0(2);
            }
            return flutterModuleStep;
        }

        @Override
        @NotNull
        public FlutterProjectStep createFlutterStep(@NotNull FlutterProjectModel model) {
            if (model == null) {
                FlutterPackageGalleryEntry.$$$reportNull$$$0(3);
            }
            FlutterProjectStep flutterProjectStep = new FlutterProjectStep(model, FlutterBundle.message((String)"module.wizard.package_step_title", (Object[])new Object[0]), FlutterIcons.Flutter_64, FlutterProjectType.PACKAGE);
            if (flutterProjectStep == null) {
                FlutterPackageGalleryEntry.$$$reportNull$$$0(4);
            }
            return flutterProjectStep;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/module/FlutterDescriptionProvider$FlutterPackageGalleryEntry";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/module/FlutterDescriptionProvider$FlutterPackageGalleryEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStep";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFlutterStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createFlutterStep";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FlutterApplicationGalleryEntry
    extends FlutterGalleryEntry {
        private FlutterApplicationGalleryEntry(OptionalValueProperty<FlutterProjectModel> sharedModel) {
            super(sharedModel);
        }

        @Nullable
        public Image getIcon() {
            return IconUtil.toImage((Icon)FlutterIcons.AndroidStudioNewProject);
        }

        @NotNull
        public String getName() {
            String string = FlutterBundle.message((String)"module.wizard.app_title", (Object[])new Object[0]);
            if (string == null) {
                FlutterApplicationGalleryEntry.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public String getDescription() {
            return FlutterBundle.message((String)"module.wizard.app_description", (Object[])new Object[0]);
        }

        @Override
        @Nullable
        public String getHelpText() {
            return FlutterBundle.message((String)"flutter.module.create.settings.help.project_type.description.app", (Object[])new Object[0]);
        }

        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            if (model == null) {
                FlutterApplicationGalleryEntry.$$$reportNull$$$0(1);
            }
            FlutterModuleStep flutterModuleStep = new FlutterModuleStep(this.model(model, FlutterProjectType.APP), FlutterBundle.message((String)"module.wizard.app_step_title", (Object[])new Object[0]), FlutterIcons.Flutter_64, FlutterProjectType.APP);
            if (flutterModuleStep == null) {
                FlutterApplicationGalleryEntry.$$$reportNull$$$0(2);
            }
            return flutterModuleStep;
        }

        @Override
        @NotNull
        public FlutterProjectStep createFlutterStep(FlutterProjectModel model) {
            FlutterProjectStep flutterProjectStep = new FlutterProjectStep(model, FlutterBundle.message((String)"module.wizard.app_step_title", (Object[])new Object[0]), FlutterIcons.Flutter_64, FlutterProjectType.APP);
            if (flutterProjectStep == null) {
                FlutterApplicationGalleryEntry.$$$reportNull$$$0(3);
            }
            return flutterProjectStep;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/module/FlutterDescriptionProvider$FlutterApplicationGalleryEntry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/module/FlutterDescriptionProvider$FlutterApplicationGalleryEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStep";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFlutterStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class FlutterGalleryEntry
    implements ModuleGalleryEntry {
        private OptionalValueProperty<FlutterProjectModel> mySharedModel;

        private FlutterGalleryEntry(OptionalValueProperty<FlutterProjectModel> sharedModel) {
            this.mySharedModel = sharedModel;
        }

        protected FlutterProjectModel model(NewModuleModel npwModel, FlutterProjectType type) {
            if (!((Boolean)this.mySharedModel.isPresent().get()).booleanValue()) {
                this.mySharedModel.setValue((Object)new FlutterModuleModel(type));
                ((FlutterProjectModel)((Object)this.mySharedModel.getValue())).project().setValue(npwModel.getProject().getValue());
            }
            return (FlutterProjectModel)((Object)this.mySharedModel.getValue());
        }

        @NotNull
        public abstract FlutterProjectStep createFlutterStep(FlutterProjectModel var1);

        @Nullable
        public abstract String getHelpText();

        public String toString() {
            return this.getName();
        }
    }
}

