/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.android;

import com.android.prefs.AndroidLocation;
import com.android.tools.idea.gradle.project.common.GradleInitScripts;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.hash.HashMap;
import io.flutter.FlutterUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GradleDependencyFetcher {
    private static final Logger LOG = Logger.getInstance(GradleDependencyFetcher.class);
    private static final String DEP_COMMENT = " - ";
    private static final String DEP_LIST_ITEM = "+---";
    private static final String DEP_LIST_END = "\\---";
    private static final String DEP_LIST_TERMINATOR = "--- ";
    private final Project myProject;
    private final Map<String, List<String>> myDependencies;
    private String myType;
    private String mySection;
    private List<String> mySectionDependencies;

    public GradleDependencyFetcher(@NotNull Project project) {
        if (project == null) {
            GradleDependencyFetcher.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDependencies = new HashMap(15);
    }

    @NotNull
    public Map<String, List<String>> getDependencies() {
        Map<String, List<String>> map = this.myDependencies;
        if (map == null) {
            GradleDependencyFetcher.$$$reportNull$$$0(1);
        }
        return map;
    }

    public void run() {
        String path = this.myProject.getBaseDir().getPath();
        File dir = new File(path, "android");
        this.runIn(dir);
    }

    private void runIn(@NotNull File base) {
        File gradlew;
        if (base == null) {
            GradleDependencyFetcher.$$$reportNull$$$0(2);
        }
        if (!(gradlew = new File(base, GradleDependencyFetcher.isWindows() ? "gradlew.bat" : "gradlew")).exists() || !gradlew.canExecute()) {
            FlutterUtils.warn((Logger)LOG, (String)"Cannot run gradle");
            return;
        }
        File pwd = base.getAbsoluteFile();
        ArrayList args = Lists.newArrayList();
        args.add(gradlew.getAbsolutePath());
        String customizedGradleHome = System.getProperty("gradle.user.home");
        if (customizedGradleHome != null) {
            args.add("-g");
            args.add(customizedGradleHome);
        }
        args.add("androidDependencies");
        GradleInitScripts.getInstance().addLocalMavenRepoInitScriptCommandLineArg((List)args);
        GeneralCommandLine cmdLine = new GeneralCommandLine((List)args).withWorkDirectory(pwd);
        cmdLine.withEnvironment("JAVA_HOME", EmbeddedDistributionPaths.getInstance().getEmbeddedJdkPath().getAbsolutePath());
        try {
            cmdLine.withEnvironment("ANDROID_SDK_HOME", AndroidLocation.getFolder());
        }
        catch (AndroidLocation.AndroidLocationException e) {
            FlutterUtils.warn((Logger)LOG, (String)"No Android SDK", (Throwable)e);
            return;
        }
        String result = "NO OUTPUT";
        try {
            CapturingProcessHandler process = new CapturingProcessHandler(cmdLine);
            int timeoutInMilliseconds = 120000;
            ProcessOutput processOutput = process.runProcess(timeoutInMilliseconds, true);
            if (processOutput.isTimeout()) {
                FlutterUtils.warn((Logger)LOG, (String)"Dependency processing time-out");
                return;
            }
            String errors = processOutput.getStderr();
            String output = processOutput.getStdout();
            int exitCode = processOutput.getExitCode();
            if (exitCode != 0) {
                FlutterUtils.warn((Logger)LOG, (String)("Error " + String.valueOf(exitCode) + " during dependency analysis: " + errors));
                return;
            }
            result = output;
        }
        catch (ExecutionException e) {
            FlutterUtils.warn((Logger)LOG, (String)"Dependency process exception", (Throwable)e);
        }
        this.parseDependencies(result);
    }

    public void parseDependencies(String result) {
        try (BufferedReader reader = new BufferedReader(new StringReader(result));){
            reader.lines().forEach(this::parseLine);
        }
        catch (IOException ex) {
            FlutterUtils.warn((Logger)LOG, (Throwable)ex);
        }
    }

    private void parseLine(String line) {
        line = line.trim();
        if (this.mySection == null && !line.contains(DEP_COMMENT)) {
            this.myType = null;
        }
        if (this.myType == null) {
            this.myType = line;
            this.mySection = null;
            this.mySectionDependencies = null;
        } else if (this.mySection == null) {
            this.mySection = line.substring(0, line.indexOf(DEP_COMMENT));
            this.mySectionDependencies = Lists.newArrayList();
        } else if (line.startsWith(DEP_LIST_ITEM)) {
            this.mySectionDependencies.add(line.substring(line.indexOf(DEP_LIST_TERMINATOR) + DEP_LIST_TERMINATOR.length()));
        } else if (line.startsWith(DEP_LIST_END)) {
            this.mySectionDependencies.add(line.substring(line.indexOf(DEP_LIST_TERMINATOR) + DEP_LIST_TERMINATOR.length()));
            this.myDependencies.put(this.mySection, this.mySectionDependencies);
            this.mySection = null;
        }
    }

    private static boolean isWindows() {
        return SdkUtils.startsWithIgnoreCase((String)System.getProperty("os.name"), (String)"windows");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/android/GradleDependencyFetcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/android/GradleDependencyFetcher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

