/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.android;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ProjectTopics;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.IdeaProjectModelModifier;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.modules.CircularModuleDependenciesDetector;
import io.flutter.android.AndroidModuleLibraryProperties;
import io.flutter.android.AndroidModuleLibraryType;
import io.flutter.sdk.AbstractLibraryManager;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.utils.FlutterModuleUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleLibraryManager
extends AbstractLibraryManager<AndroidModuleLibraryProperties> {
    private static final Logger LOG = Logger.getInstance(AndroidModuleLibraryManager.class);
    private static final String BUILD_FILE_NAME = "build.gradle";
    private final AtomicBoolean isUpdating;

    public AndroidModuleLibraryManager(@NotNull Project project) {
        if (project == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(0);
        }
        super(project);
        this.isUpdating = new AtomicBoolean(false);
    }

    public void update() {
        this.doGradleSync(this.getProject(), this::scheduleAddAndroidLibraryDeps);
    }

    private Void scheduleAddAndroidLibraryDeps(@NotNull Project androidProject) {
        if (androidProject == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.addAndroidLibraryDependencies(androidProject), ModalityState.NON_MODAL);
        return null;
    }

    private void addAndroidLibraryDependencies(@NotNull Project androidProject) {
        if (androidProject == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(2);
        }
        for (Module flutterModule : FlutterModuleUtils.getModules((Project)this.getProject())) {
            if (!FlutterModuleUtils.isFlutterModule((Module)flutterModule)) continue;
            for (Module module : ModuleManager.getInstance((Project)androidProject).getModules()) {
                this.addAndroidLibraryDependencies(androidProject, module, flutterModule);
            }
        }
        this.isUpdating.set(false);
    }

    private void addAndroidLibraryDependencies(@NotNull Project androidProject, @NotNull Module androidModule, @NotNull Module flutterModule) {
        if (androidProject == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(3);
        }
        if (androidModule == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(4);
        }
        if (flutterModule == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(5);
        }
        AndroidSdkUtils.setupAndroidPlatformIfNecessary((Module)androidModule, (boolean)true);
        Sdk currentSdk = ModuleRootManager.getInstance((Module)androidModule).getSdk();
        if (currentSdk != null) {
            // empty if block
        }
        LibraryTable androidProjectLibraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(androidProject);
        Library[] androidProjectLibraries = androidProjectLibraryTable.getLibraries();
        LibraryTable flutterProjectLibraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.getProject());
        Library[] flutterProjectLibraries = flutterProjectLibraryTable.getLibraries();
        HashSet knownLibraryNames = new HashSet(flutterProjectLibraries.length);
        for (Library lib : flutterProjectLibraries) {
            if (lib.getName() == null) continue;
            knownLibraryNames.add(lib.getName());
        }
        for (Library library : androidProjectLibraries) {
            List<String> roots;
            Set filteredRoots;
            if (library.getName() == null || knownLibraryNames.contains(library.getName()) || (filteredRoots = (roots = Arrays.asList(library.getRootProvider().getUrls(OrderRootType.CLASSES))).stream().filter(s -> AndroidModuleLibraryManager.shouldIncludeRoot(s)).collect(Collectors.toSet())).isEmpty()) continue;
            HashSet sources = new HashSet();
            sources.addAll(Arrays.asList(library.getRootProvider().getUrls(OrderRootType.SOURCES)));
            this.updateLibraryContent(library.getName(), filteredRoots, (Set)sources);
            this.updateAndroidModuleLibraryDependencies(flutterModule);
        }
    }

    protected void updateModuleLibraryDependencies(@NotNull Library library) {
        if (library == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(6);
        }
        for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (!FlutterModuleUtils.declaresFlutter((Module)module)) {
                AndroidModuleLibraryManager.addFlutterLibraryDependency((Module)module, (Library)library);
                continue;
            }
            AndroidModuleLibraryManager.removeFlutterLibraryDependency((Module)module, (Library)library);
        }
    }

    private void updateAndroidModuleLibraryDependencies(Module flutterModule) {
        for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            JavaProjectModelModifier[] modifiers;
            ModuleRootManager rootManager;
            Couple circularModules;
            if (module == flutterModule || null == FacetManager.getInstance((Module)module).findFacet(AndroidFacet.ID, "Android") || (circularModules = CircularModuleDependenciesDetector.addingDependencyFormsCircularity((Module)module, (Module)flutterModule)) != null || (rootManager = ModuleRootManager.getInstance((Module)module)).isDependsOn(flutterModule)) continue;
            for (JavaProjectModelModifier modifier : modifiers = (JavaProjectModelModifier[])JavaProjectModelModifier.EP_NAME.getExtensions((AreaInstance)this.getProject())) {
                if (!(modifier instanceof IdeaProjectModelModifier)) continue;
                modifier.addModuleDependency(module, flutterModule, DependencyScope.COMPILE, false);
            }
        }
    }

    @NotNull
    protected String getLibraryName() {
        if ("Android Libraries" == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(7);
        }
        return "Android Libraries";
    }

    @NotNull
    protected PersistentLibraryKind<AndroidModuleLibraryProperties> getLibraryKind() {
        PersistentLibraryKind<AndroidModuleLibraryProperties> persistentLibraryKind = AndroidModuleLibraryType.LIBRARY_KIND;
        if (persistentLibraryKind == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(8);
        }
        return persistentLibraryKind;
    }

    private void scheduleUpdate() {
        if (this.isUpdating.get()) {
            return;
        }
        Runnable runnable = this::updateAndroidLibraries;
        DumbService.getInstance((Project)this.getProject()).smartInvokeLater(runnable, ModalityState.NON_MODAL);
    }

    private void updateAndroidLibraries() {
        if (!this.isUpdating.compareAndSet(false, true)) {
            return;
        }
        this.update();
    }

    private void doGradleSync(Project flutterProject, final Function<Project, Void> callback) {
        VirtualFile dir = flutterProject.getBaseDir().findChild("android");
        if (dir == null) {
            dir = flutterProject.getBaseDir().findChild(".android");
        }
        assert (dir != null);
        final EmbeddedAndroidProject androidProject = new EmbeddedAndroidProject(FileUtilRt.toSystemIndependentName((String)dir.getPath()), null);
        androidProject.init();
        GradleSyncListener listener = new GradleSyncListener(){

            public void syncTaskCreated(@NotNull Project project, @NotNull GradleSyncInvoker.Request request) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (request == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            public void syncStarted(@NotNull Project project, boolean skipped, boolean sourceGenerationRequested) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            public void setupStarted(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
            }

            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (AndroidModuleLibraryManager.this.isUpdating.get()) {
                    callback.apply(androidProject);
                }
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(6);
                }
                AndroidModuleLibraryManager.this.isUpdating.set(false);
            }

            public void syncSkipped(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(7);
                }
                AndroidModuleLibraryManager.this.isUpdating.set(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "io/flutter/android/AndroidModuleLibraryManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncTaskCreated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncStarted";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setupStarted";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSucceeded";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncFailed";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSkipped";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
        request.runInBackground = true;
        GradleSyncInvoker gradleSyncInvoker = (GradleSyncInvoker)ServiceManager.getService(GradleSyncInvoker.class);
        gradleSyncInvoker.requestProjectSync((Project)androidProject, request, listener);
    }

    private static boolean shouldIncludeRoot(String path) {
        return !path.endsWith("res") && !path.contains("flutter.jar") && !path.contains("flutter-x86.jar");
    }

    @NotNull
    public static AndroidModuleLibraryManager getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(9);
        }
        AndroidModuleLibraryManager androidModuleLibraryManager = (AndroidModuleLibraryManager)((Object)ServiceManager.getService((Project)project, AndroidModuleLibraryManager.class));
        if (androidModuleLibraryManager == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(10);
        }
        return androidModuleLibraryManager;
    }

    public static void startWatching(final @NotNull Project project) {
        if (project == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(11);
        }
        if (project.isDefault()) {
            return;
        }
        if (AndroidModuleLibraryManager.hasAndroidDir(project)) {
            final AndroidModuleLibraryManager manager = AndroidModuleLibraryManager.getInstance(project);
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileContentsChangedAdapter(){

                protected void onFileChange(@NotNull VirtualFile file) {
                    if (file == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    AndroidModuleLibraryManager.fileChanged(project, file);
                }

                protected void onBeforeFileChange(@NotNull VirtualFile file) {
                    if (file == null) {
                        2.$$$reportNull$$$0(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "file";
                    objectArray2[1] = "io/flutter/android/AndroidModuleLibraryManager$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onFileChange";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onBeforeFileChange";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)project);
            project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                public void rootsChanged(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    manager.scheduleUpdate();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/android/AndroidModuleLibraryManager$3", "rootsChanged"));
                }
            });
            manager.scheduleUpdate();
        }
    }

    private static boolean hasAndroidDir(Project project) {
        if (FlutterSdkUtil.hasFlutterModules((Project)project)) {
            VirtualFile base = project.getBaseDir();
            VirtualFile dir = base.findChild("android");
            if (dir == null) {
                dir = base.findChild(".android");
            }
            return dir != null;
        }
        return false;
    }

    private static void fileChanged(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(12);
        }
        if (file == null) {
            AndroidModuleLibraryManager.$$$reportNull$$$0(13);
        }
        if (!BUILD_FILE_NAME.equals(file.getName())) {
            return;
        }
        if (LocalFileSystem.getInstance() != file.getFileSystem() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)project.getBaseDir(), (VirtualFile)file, (boolean)true)) {
            return;
        }
        AndroidModuleLibraryManager.getInstance(project).scheduleUpdate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModule";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flutterModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/android/AndroidModuleLibraryManager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/android/AndroidModuleLibraryManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryKind";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAddAndroidLibraryDeps";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAndroidLibraryDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateModuleLibraryDependencies";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "startWatching";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fileChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmbeddedAndroidProject
    extends ProjectImpl {
        protected EmbeddedAndroidProject(@NotNull String filePath, @Nullable String projectName) {
            if (filePath == null) {
                EmbeddedAndroidProject.$$$reportNull$$$0(0);
            }
            super(filePath, projectName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "io/flutter/android/AndroidModuleLibraryManager$EmbeddedAndroidProject", "<init>"));
        }
    }
}

