/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.OffsetIcon;
import com.intellij.util.ui.JBUI;
import icons.FlutterIcons;
import io.flutter.module.FlutterProjectType;
import io.flutter.project.ChoseProjectTypeStep;
import io.flutter.project.FlutterProjectModel;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FlutterNewProjectAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(FlutterNewProjectAction.class);

    public FlutterNewProjectAction() {
        this("New Flutter Project...");
    }

    public FlutterNewProjectAction(@NotNull String text) {
        if (text == null) {
            FlutterNewProjectAction.$$$reportNull$$$0(0);
        }
        super(text);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FlutterNewProjectAction.$$$reportNull$$$0(1);
        }
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            e.getPresentation().setIcon(this.getFlutterDecoratedIcon());
            e.getPresentation().setText("Start a new Flutter project");
        }
    }

    public void actionPerformed(AnActionEvent e) {
        FlutterProjectModel model = new FlutterProjectModel(FlutterProjectType.APP);
        ModelWizard wizard = new ModelWizard.Builder(new ModelWizardStep[0]).addStep((ModelWizardStep)new ChoseProjectTypeStep(model)).build();
        StudioWizardDialogBuilder builder = new StudioWizardDialogBuilder(wizard, "Create New Flutter Project");
        builder.setUxStyle(StudioWizardDialogBuilder.UxStyle.DYNAMIC_APP);
        ModelWizardDialog dialog = builder.build();
        try {
            dialog.show();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    Icon getFlutterDecoratedIcon() {
        Icon icon = AllIcons.Welcome.CreateNewProject;
        JBUI.CachingScalableJBIcon badgeIcon = new OffsetIcon(0, FlutterIcons.Flutter_badge).scale(0.666f);
        LayeredIcon decorated = new LayeredIcon(2);
        decorated.setIcon((Icon)badgeIcon, 0, 7, 7);
        decorated.setIcon(icon, 1, 0, 0);
        return decorated;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/FlutterNewProjectAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

