/*
 * Decompiled with CFR 0.152.
 */
package de.roderick.weberknecht;

import de.roderick.weberknecht.WebSocket;
import de.roderick.weberknecht.WebSocketException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public class WebSocketHandshake {
    private String host;
    private int port;
    private String path;
    private String protocol = null;
    private String nonce = null;
    private Map<String, String> extraHeaders = null;

    public WebSocketHandshake(String host, int port, String path, String protocol, Map<String, String> extraHeaders) {
        this.host = host;
        this.port = port;
        this.path = path;
        this.protocol = protocol;
        this.extraHeaders = extraHeaders;
        this.nonce = this.createNonce();
    }

    public byte[] getHandshake() {
        String hostString = this.host;
        if (hostString == null) {
            hostString = "localhost";
        }
        if (this.port != -1) {
            hostString = hostString + ":" + this.port;
        }
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        header.put("Host", hostString);
        header.put("Upgrade", "websocket");
        header.put("Connection", "Upgrade");
        header.put("Sec-WebSocket-Version", String.valueOf(WebSocket.getVersion()));
        header.put("Sec-WebSocket-Key", this.nonce);
        if (this.protocol != null) {
            header.put("Sec-WebSocket-Protocol", this.protocol);
        }
        if (this.extraHeaders != null) {
            for (String fieldName : this.extraHeaders.keySet()) {
                if (header.containsKey(fieldName)) continue;
                header.put(fieldName, this.extraHeaders.get(fieldName));
            }
        }
        String handshake = "GET " + this.path + " HTTP/1.1\r\n";
        handshake = handshake + this.generateHeader(header);
        handshake = handshake + "\r\n";
        byte[] handshakeBytes = new byte[handshake.getBytes().length];
        System.arraycopy(handshake.getBytes(), 0, handshakeBytes, 0, handshake.getBytes().length);
        return handshakeBytes;
    }

    public void verifyServerHandshakeHeaders(HashMap<String, String> headers) throws WebSocketException {
        if (!headers.get("upgrade").equalsIgnoreCase("websocket")) {
            throw new WebSocketException("connection failed: missing header field in server handshake: upgrade");
        }
        if (!headers.get("connection").equalsIgnoreCase("upgrade")) {
            throw new WebSocketException("connection failed: missing header field in server handshake: connection");
        }
    }

    public void verifyServerStatusLine(String statusLine) throws WebSocketException {
        int statusCode = Integer.valueOf(statusLine.substring(9, 12));
        if (statusCode == 407) {
            throw new WebSocketException("connection failed: proxy authentication not supported");
        }
        if (statusCode == 404) {
            throw new WebSocketException("connection failed: 404 not found");
        }
        if (statusCode != 101) {
            throw new WebSocketException("connection failed: unknown status code " + statusCode);
        }
    }

    private String createNonce() {
        byte[] nonce = new byte[16];
        for (int i = 0; i < 16; ++i) {
            nonce[i] = (byte)this.rand(0, 255);
        }
        return this.encodeBase64String(nonce);
    }

    private String encodeBase64String(byte[] data) {
        return DatatypeConverter.printBase64Binary((byte[])data);
    }

    private String generateHeader(LinkedHashMap<String, String> headers) {
        String header = new String();
        for (String fieldName : headers.keySet()) {
            header = header + fieldName + ": " + headers.get(fieldName) + "\r\n";
        }
        return header;
    }

    private int rand(int min, int max) {
        int rand = (int)(Math.random() * (double)max + (double)min);
        return rand;
    }
}

