/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.xml;

import com.github.megatronking.svg.generator.utils.Color;
import com.github.megatronking.svg.generator.utils.Dimen;
import com.github.megatronking.svg.generator.utils.SCU;
import com.github.megatronking.svg.generator.xml.IAttributeParser;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class CommonAbstractAttributeParser<T>
implements IAttributeParser<T> {
    protected String parseString(Element element, String name) {
        Attribute attribute = element.attribute(name);
        return attribute == null ? null : attribute.getValue();
    }

    protected String parseString(Element element, String name, String defaultValue) {
        Attribute attribute = element.attribute(name);
        String value = attribute == null ? null : attribute.getValue();
        return value == null || value.trim().length() == 0 ? defaultValue : value;
    }

    protected float parseFloat(Element element, String name) {
        return this.parseFloat(element, name, 0.0f);
    }

    protected float parseFloat(Element element, String name, float defaultValue) {
        return SCU.parseFloat(this.parseString(element, name), defaultValue);
    }

    protected boolean parseBoolean(Element element, String name) {
        return this.parseBoolean(element, name, false);
    }

    protected boolean parseBoolean(Element element, String name, boolean defaultValue) {
        return SCU.parseBoolean(this.parseString(element, name), defaultValue);
    }

    protected int parseColor(Element element, String name) {
        return Color.convert(this.parseString(element, name));
    }

    protected int parseColor(Element element, String name, int defaultColor) {
        return Color.convert(this.parseString(element, name), defaultColor);
    }

    protected float parseDimen(Element element, String name) {
        return Dimen.convert(this.parseString(element, name));
    }
}

