/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.writer.impl;

import com.github.megatronking.svg.generator.render.VectorRenderer;
import com.github.megatronking.svg.generator.utils.Dimen;
import com.github.megatronking.svg.generator.vector.model.Vector;
import com.github.megatronking.svg.generator.writer.JavaClassWriter;
import java.io.BufferedWriter;
import java.io.IOException;

public class SVGRendererTemplateWriter
extends JavaClassWriter {
    private VectorRenderer mRenderer;
    private Vector mVector;

    public SVGRendererTemplateWriter(VectorRenderer renderer, Vector vector) {
        this.mRenderer = renderer;
        this.mVector = vector;
        this.setClassRelation("SVGRenderer", null);
    }

    @Override
    protected void writeImports(BufferedWriter bw) throws IOException {
        super.writeImports(bw);
        bw.write("import android.content.Context;");
        bw.newLine();
        bw.write("import android.graphics.Canvas;");
        bw.newLine();
        bw.write("import android.graphics.ColorFilter;");
        bw.newLine();
        bw.write("import android.graphics.Paint;");
        bw.newLine();
        bw.newLine();
        bw.write("import com.github.megatronking.svg.support.SVGRenderer;");
        bw.newLine();
        bw.newLine();
    }

    @Override
    protected void writeClassComment(BufferedWriter bw) throws IOException {
        super.writeClassComment(bw);
        bw.write("/**");
        bw.newLine();
        bw.write(" * AUTO-GENERATED FILE.  DO NOT MODIFY.");
        bw.newLine();
        bw.write(" * ");
        bw.newLine();
        bw.write(" * This class was automatically generated by the");
        bw.newLine();
        bw.write(" * SVG-Generator. It should not be modified by hand.");
        bw.newLine();
        bw.write(" */");
    }

    @Override
    protected void writeFields(BufferedWriter bw) throws IOException {
    }

    @Override
    protected void writeConstructMethods(BufferedWriter bw) throws IOException {
        bw.newLine();
        bw.write("    public " + this.mClassSimpleName + "(Context context) {");
        bw.newLine();
        bw.write("        super(context);");
        bw.newLine();
        bw.write("        mAlpha = " + this.mVector.alpha + "f;");
        bw.newLine();
        bw.write("        mWidth = " + this.getDimenSize(this.mVector.width) + ";");
        bw.newLine();
        bw.write("        mHeight = " + this.getDimenSize(this.mVector.height) + ";");
        bw.newLine();
        bw.write("    }");
        bw.newLine();
    }

    @Override
    protected void writeMethods(BufferedWriter bw) throws IOException {
        this.writeMethodRender(bw);
    }

    private void writeMethodRender(BufferedWriter bw) throws IOException {
        bw.newLine();
        bw.write("    @Override");
        bw.newLine();
        bw.write("    public void render(Canvas canvas, int w, int h, ColorFilter filter) {");
        bw.newLine();
        bw.write(this.mRenderer.renderResult());
        bw.newLine();
        bw.write("    }");
        bw.newLine();
    }

    private String getDimenSize(String size) {
        if (Dimen.isDip(size)) {
            return "dip2px(" + Dimen.convert(size) + "f)";
        }
        if (Dimen.isPx(size)) {
            return "(int)" + Dimen.convert(size) + "f";
        }
        return "0f";
    }
}

