/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.writer.impl;

import com.github.megatronking.svg.generator.writer.JavaClassWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SVGLoaderTemplateWriter
extends JavaClassWriter {
    private String mPackageName;
    private List<String> mDrawableRendererList = new ArrayList<String>();

    public SVGLoaderTemplateWriter(String packageName) {
        this.mPackageName = packageName;
        this.setClassSimpleName("SVGLoader");
    }

    public void addRendererName(String name) {
        this.mDrawableRendererList.add(name);
    }

    @Override
    protected void writeImports(BufferedWriter bw) throws IOException {
        super.writeImports(bw);
        bw.newLine();
        bw.write("import " + this.mPackageName + ".R;");
        bw.newLine();
        bw.newLine();
        bw.write("import android.content.Context;");
        bw.newLine();
        bw.write("import android.graphics.drawable.Drawable;");
        bw.newLine();
        bw.write("import android.util.LongSparseArray;");
        bw.newLine();
        bw.newLine();
        bw.write("import com.github.megatronking.svg.support.SVGDrawable;");
        bw.newLine();
        bw.write("import com.github.megatronking.svg.support.SVGHelper;");
        bw.newLine();
        bw.newLine();
    }

    @Override
    protected void writeFields(BufferedWriter bw) throws IOException {
        bw.newLine();
        bw.write("    private static LongSparseArray<Drawable.ConstantState> sPreloadedDrawables;");
        bw.newLine();
    }

    @Override
    protected void writeClassComment(BufferedWriter bw) throws IOException {
        super.writeClassComment(bw);
        bw.write("/**");
        bw.newLine();
        bw.write(" * AUTO-GENERATED FILE.  DO NOT MODIFY.");
        bw.newLine();
        bw.write(" * ");
        bw.newLine();
        bw.write(" * This class was automatically generated by the");
        bw.newLine();
        bw.write(" * SVG-Generator. It should not be modified by hand.<br><br>");
        bw.newLine();
        bw.write(" *");
        bw.newLine();
        bw.write(" * Call the follow in your Application: ");
        bw.newLine();
        bw.write(" *");
        bw.newLine();
        bw.write(" * <pre class=\"prettyprint\">");
        bw.newLine();
        bw.write(" * public class MyApplication extends Application {");
        bw.newLine();
        bw.write(" *");
        bw.newLine();
        bw.write(" *    public void onCreate() {");
        bw.newLine();
        bw.write(" *        SVGLoader.load(this)");
        bw.newLine();
        bw.write(" *    }");
        bw.newLine();
        bw.write(" *");
        bw.newLine();
        bw.write(" * }");
        bw.newLine();
        bw.write(" * </pre>");
        bw.newLine();
        bw.write(" */");
    }

    @Override
    protected void writeConstructMethods(BufferedWriter bw) throws IOException {
    }

    @Override
    protected void writeMethods(BufferedWriter bw) throws IOException {
        this.writeLoadMethod(bw);
        this.writeAddMethod(bw);
    }

    private void writeLoadMethod(BufferedWriter bw) throws IOException {
        bw.newLine();
        bw.write("    public static void load(Context context) {");
        bw.newLine();
        bw.write("        sPreloadedDrawables = SVGHelper.hackPreloadDrawables(context.getResources());");
        bw.newLine();
        bw.write("        if (sPreloadedDrawables == null) {");
        bw.newLine();
        bw.write("            return;");
        bw.newLine();
        bw.write("        }");
        bw.newLine();
        for (String name : this.mDrawableRendererList) {
            bw.write("        add(context, R.drawable." + name + ", " + "SVGDrawable.SVGDrawableConstantState.create(new " + name + "(context)));");
            bw.newLine();
        }
        bw.write("    }");
        bw.newLine();
    }

    private void writeAddMethod(BufferedWriter bw) throws IOException {
        bw.newLine();
        bw.write("    private static void add(Context context, int resId, SVGDrawable.SVGDrawableConstantState state) {");
        bw.newLine();
        bw.write("        sPreloadedDrawables.put(SVGHelper.resKey(context, resId), state);");
        bw.newLine();
        bw.write("    }");
        bw.newLine();
    }
}

