/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.writer;

import com.github.megatronking.svg.generator.writer.IBufferWriter;
import java.io.BufferedWriter;
import java.io.IOException;

public abstract class JavaClassWriter
implements IBufferWriter {
    public static final String HEAD_SPACE = "    ";
    private String mPackage;
    private String[] mImports;
    protected String mClassSimpleName;
    private String mClassModifiers = "public";
    private String mClassExtends;
    private String[] mClassImplements;

    protected abstract void writeFields(BufferedWriter var1) throws IOException;

    protected abstract void writeConstructMethods(BufferedWriter var1) throws IOException;

    protected abstract void writeMethods(BufferedWriter var1) throws IOException;

    public void setPackage(String packageInfo) {
        this.mPackage = packageInfo;
    }

    public void setImports(String[] imports) {
        this.mImports = imports;
    }

    public void setClassSimpleName(String classSimpleName) {
        this.mClassSimpleName = classSimpleName;
    }

    public void setClassModifiers(String classModifiers) {
        this.mClassModifiers = classModifiers;
    }

    public void setClassRelation(String classExtends, String[] classImplements) {
        this.mClassExtends = classExtends;
        this.mClassImplements = classImplements;
    }

    @Override
    public void write(BufferedWriter bw) throws IOException {
        this.writePackage(bw);
        this.writeImports(bw);
        this.writeClassComment(bw);
        this.writeClass(bw);
        this.writeFields(bw);
        this.writeConstructMethods(bw);
        this.writeMethods(bw);
        this.writeInnerClasses(bw);
        this.writeEnd(bw);
        bw.flush();
        bw.close();
    }

    protected void writePackage(BufferedWriter bw) throws IOException {
        bw.write("package " + this.mPackage + ";");
        bw.newLine();
        bw.newLine();
    }

    protected void writeImports(BufferedWriter bw) throws IOException {
        if (this.mImports != null && this.mImports.length != 0) {
            for (int i = 0; i < this.mImports.length; ++i) {
                bw.write("import " + this.mImports[i] + ";");
                bw.newLine();
            }
            bw.newLine();
        }
    }

    protected void writeClassComment(BufferedWriter bw) throws IOException {
    }

    protected void writeClass(BufferedWriter bw) throws IOException {
        bw.newLine();
        bw.write(this.mClassModifiers + " class " + this.mClassSimpleName + " ");
        if (this.mClassExtends != null && this.mClassExtends.length() != 0) {
            bw.write("extends " + this.mClassExtends);
        }
        if (this.mClassImplements != null && this.mClassImplements.length != 0) {
            bw.write(" implements ");
            for (int i = 0; i < this.mClassImplements.length; ++i) {
                bw.write(this.mClassImplements[i]);
                if (i == this.mClassImplements.length - 1) continue;
                bw.write(", ");
            }
        }
        bw.write(" {");
        bw.newLine();
    }

    protected void writeInnerClasses(BufferedWriter bw) throws IOException {
    }

    protected void writeEnd(BufferedWriter bw) throws IOException {
        bw.newLine();
        bw.write("}");
    }
}

