/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.utils;

import com.github.megatronking.svg.generator.utils.FloatUtils;
import java.util.ArrayList;

public class PathDataNode {
    public char type;
    public float[] params;

    private PathDataNode(char type, float[] params) {
        this.type = type;
        this.params = params;
    }

    public void transform(float a, float b, float c, float d, float e, float f, float[] pre) {
        switch (this.type) {
            case 'Z': 
            case 'z': {
                return;
            }
            case 'L': 
            case 'M': 
            case 'T': {
                int incr = 2;
                pre[0] = this.params[this.params.length - 2];
                pre[1] = this.params[this.params.length - 1];
                for (int i = 0; i < this.params.length; i += incr) {
                    this.matrix(a, b, c, d, e, f, i, i + 1);
                }
                break;
            }
            case 'l': 
            case 'm': 
            case 't': {
                int incr = 2;
                pre[0] = pre[0] + this.params[this.params.length - 2];
                pre[1] = pre[1] + this.params[this.params.length - 1];
                for (int i = 0; i < this.params.length; i += incr) {
                    this.matrix(a, b, c, d, 0.0f, 0.0f, i, i + 1);
                }
                break;
            }
            case 'h': {
                this.type = (char)108;
                pre[0] = pre[0] + this.params[this.params.length - 1];
                float[] tempParams = new float[this.params.length * 2];
                float[] origParams = this.params;
                this.params = tempParams;
                for (int i = 0; i < this.params.length; i += 2) {
                    this.params[i] = origParams[i / 2];
                    this.params[i + 1] = 0.0f;
                    this.matrix(a, b, c, d, 0.0f, 0.0f, i, i + 1);
                }
                break;
            }
            case 'H': {
                this.type = (char)76;
                pre[0] = this.params[this.params.length - 1];
                float[] tempParams = new float[this.params.length * 2];
                float[] origParams = this.params;
                this.params = tempParams;
                for (int i = 0; i < this.params.length; i += 2) {
                    this.params[i] = origParams[i / 2];
                    this.params[i + 1] = pre[1];
                    this.matrix(a, b, c, d, e, f, i, i + 1);
                }
                break;
            }
            case 'v': {
                pre[1] = pre[1] + this.params[this.params.length - 1];
                this.type = (char)108;
                float[] tempParams = new float[this.params.length * 2];
                float[] origParams = this.params;
                this.params = tempParams;
                for (int i = 0; i < this.params.length; i += 2) {
                    this.params[i] = 0.0f;
                    this.params[i + 1] = origParams[i / 2];
                    this.matrix(a, b, c, d, 0.0f, 0.0f, i, i + 1);
                }
                break;
            }
            case 'V': {
                this.type = (char)76;
                pre[1] = this.params[this.params.length - 1];
                float[] tempParams = new float[this.params.length * 2];
                float[] origParams = this.params;
                this.params = tempParams;
                for (int i = 0; i < this.params.length; i += 2) {
                    this.params[i] = pre[0];
                    this.params[i + 1] = origParams[i / 2];
                    this.matrix(a, b, c, d, e, f, i, i + 1);
                }
                break;
            }
            case 'C': 
            case 'Q': 
            case 'S': {
                pre[0] = this.params[this.params.length - 2];
                pre[1] = this.params[this.params.length - 1];
                for (int i = 0; i < this.params.length; i += 2) {
                    this.matrix(a, b, c, d, e, f, i, i + 1);
                }
                break;
            }
            case 'c': 
            case 'q': 
            case 's': {
                pre[0] = pre[0] + this.params[this.params.length - 2];
                pre[1] = pre[1] + this.params[this.params.length - 1];
                for (int i = 0; i < this.params.length; i += 2) {
                    this.matrix(a, b, c, d, 0.0f, 0.0f, i, i + 1);
                }
                break;
            }
            case 'a': {
                int incr = 7;
                pre[0] = pre[0] + this.params[this.params.length - 2];
                pre[1] = pre[1] + this.params[this.params.length - 1];
                for (int i = 0; i < this.params.length; i += incr) {
                    this.matrix(a, b, c, d, 0.0f, 0.0f, i, i + 1);
                    double ang = Math.toRadians(this.params[i + 2]);
                    this.params[i + 2] = (float)Math.toDegrees(ang + Math.atan2(b, d));
                    this.matrix(a, b, c, d, 0.0f, 0.0f, i + 5, i + 6);
                }
                break;
            }
            case 'A': {
                int incr = 7;
                pre[0] = this.params[this.params.length - 2];
                pre[1] = this.params[this.params.length - 1];
                for (int i = 0; i < this.params.length; i += incr) {
                    this.matrix(a, b, c, d, e, f, i, i + 1);
                    double ang = Math.toRadians(this.params[i + 2]);
                    this.params[i + 2] = (float)Math.toDegrees(ang + Math.atan2(b, d));
                    this.matrix(a, b, c, d, e, f, i + 5, i + 6);
                }
                break;
            }
        }
    }

    private void matrix(float a, float b, float c, float d, float e, float f, int offx, int offy) {
        float inx = offx < 0 ? 1.0f : this.params[offx];
        float iny = offy < 0 ? 1.0f : this.params[offy];
        float x = inx * a + iny * c + e;
        float y = inx * b + iny * d + f;
        if (offx >= 0) {
            this.params[offx] = x;
        }
        if (offy >= 0) {
            this.params[offy] = y;
        }
    }

    private static float[] copyOfRange(float[] original, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int originalLength = original.length;
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        float[] result = new float[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static PathDataNode[] createNodesFromPathData(String pathData) {
        if (pathData == null) {
            return null;
        }
        int start = 0;
        int end = 1;
        ArrayList<PathDataNode> list = new ArrayList<PathDataNode>();
        while (end < pathData.length()) {
            String s = pathData.substring(start, end = PathDataNode.nextStart(pathData, end)).trim();
            if (s.length() > 0) {
                float[] val = PathDataNode.getFloats(s);
                PathDataNode.addNode(list, s.charAt(0), val);
            }
            start = end++;
        }
        if (end - start == 1 && start < pathData.length()) {
            PathDataNode.addNode(list, pathData.charAt(start), new float[0]);
        }
        return list.toArray(new PathDataNode[list.size()]);
    }

    public static void transform(float a, float b, float c, float d, float e, float f, PathDataNode[] nodes) {
        float[] pre = new float[2];
        for (PathDataNode node : nodes) {
            node.transform(a, b, c, d, e, f, pre);
        }
    }

    public static String nodeListToString(PathDataNode[] nodes) {
        String s = "";
        for (PathDataNode node : nodes) {
            s = s + node.type;
            int len = node.params.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    s = s + ((i & 1) == 1 ? "," : " ");
                }
                s = s + FloatUtils.format2String(node.params[i]);
            }
        }
        return s;
    }

    private static int nextStart(String s, int end) {
        while (end < s.length()) {
            char c = s.charAt(end);
            if (((c - 65) * (c - 90) <= 0 || (c - 97) * (c - 122) <= 0) && c != 'e' && c != 'E') {
                return end;
            }
            ++end;
        }
        return end;
    }

    private static void addNode(ArrayList<PathDataNode> list, char cmd, float[] val) {
        list.add(new PathDataNode(cmd, val));
    }

    private static float[] getFloats(String s) {
        if (s.charAt(0) == 'z' | s.charAt(0) == 'Z') {
            return new float[0];
        }
        try {
            float[] results = new float[s.length()];
            int count = 0;
            int startPosition = 1;
            int endPosition = 0;
            ExtractFloatResult result = new ExtractFloatResult();
            int totalLength = s.length();
            while (startPosition < totalLength) {
                PathDataNode.extract(s, startPosition, result);
                endPosition = result.mEndPosition;
                if (startPosition < endPosition) {
                    results[count++] = Float.parseFloat(s.substring(startPosition, endPosition));
                }
                if (result.mEndWithNegOrDot) {
                    startPosition = endPosition;
                    continue;
                }
                startPosition = endPosition + 1;
            }
            return PathDataNode.copyOfRange(results, 0, count);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("error in parsing \"" + s + "\"", e);
        }
    }

    private static void extract(String s, int start, ExtractFloatResult result) {
        int currentIndex;
        boolean foundSeparator = false;
        result.mEndWithNegOrDot = false;
        boolean secondDot = false;
        boolean isExponential = false;
        for (currentIndex = start; currentIndex < s.length(); ++currentIndex) {
            boolean isPrevExponential = isExponential;
            isExponential = false;
            char currentChar = s.charAt(currentIndex);
            switch (currentChar) {
                case ' ': 
                case ',': {
                    foundSeparator = true;
                    break;
                }
                case '-': {
                    if (currentIndex == start || isPrevExponential) break;
                    foundSeparator = true;
                    result.mEndWithNegOrDot = true;
                    break;
                }
                case '.': {
                    if (!secondDot) {
                        secondDot = true;
                        break;
                    }
                    foundSeparator = true;
                    result.mEndWithNegOrDot = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    isExponential = true;
                }
            }
            if (foundSeparator) break;
        }
        result.mEndPosition = currentIndex;
    }

    public static boolean hasRelMoveAfterClose(PathDataNode[] nodes) {
        int preType = 32;
        for (PathDataNode n : nodes) {
            if ((preType == 122 || preType == 90) && n.type == 'm') {
                return true;
            }
            preType = n.type;
        }
        return false;
    }

    private static class ExtractFloatResult {
        int mEndPosition;
        boolean mEndWithNegOrDot;

        private ExtractFloatResult() {
        }
    }
}

