/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.utils;

import java.io.PrintWriter;

public class Matrix {
    public static final int MSCALE_X = 0;
    public static final int MSKEW_X = 1;
    public static final int MTRANS_X = 2;
    public static final int MSKEW_Y = 3;
    public static final int MSCALE_Y = 4;
    public static final int MTRANS_Y = 5;
    public static final int MPERSP_0 = 6;
    public static final int MPERSP_1 = 7;
    public static final int MPERSP_2 = 8;
    private final float[] MATRIX = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    public void set(Matrix src) {
        if (src == null) {
            this.reset();
        } else {
            float[] values = new float[9];
            src.getValues(values);
            this.setValues(values);
        }
    }

    public void reset() {
        this.MATRIX[0] = 1.0f;
        this.MATRIX[1] = 0.0f;
        this.MATRIX[2] = 0.0f;
        this.MATRIX[3] = 1.0f;
        this.MATRIX[4] = 0.0f;
        this.MATRIX[5] = 0.0f;
        this.MATRIX[6] = 0.0f;
        this.MATRIX[7] = 0.0f;
        this.MATRIX[8] = 1.0f;
    }

    public void preConcat(Matrix other) {
        float[] otherValue = new float[9];
        other.getValues(otherValue);
        float[] newValue = new float[]{this.MATRIX[0] * otherValue[0] + this.MATRIX[1] * otherValue[3] + this.MATRIX[2] * otherValue[6], this.MATRIX[0] * otherValue[1] + this.MATRIX[1] * otherValue[4] + this.MATRIX[2] * otherValue[7], this.MATRIX[0] * otherValue[2] + this.MATRIX[1] * otherValue[5] + this.MATRIX[2] * otherValue[8], this.MATRIX[3] * otherValue[0] + this.MATRIX[4] * otherValue[3] + this.MATRIX[5] * otherValue[6], this.MATRIX[3] * otherValue[1] + this.MATRIX[4] * otherValue[4] + this.MATRIX[5] * otherValue[7], this.MATRIX[3] * otherValue[2] + this.MATRIX[4] * otherValue[5] + this.MATRIX[5] * otherValue[8], this.MATRIX[6] * otherValue[0] + this.MATRIX[7] * otherValue[3] + this.MATRIX[8] * otherValue[6], this.MATRIX[6] * otherValue[1] + this.MATRIX[7] * otherValue[4] + this.MATRIX[8] * otherValue[7], this.MATRIX[6] * otherValue[2] + this.MATRIX[7] * otherValue[5] + this.MATRIX[8] * otherValue[8]};
        this.setValues(newValue);
    }

    public void postTranslate(float dx, float dy) {
        Matrix matrix = new Matrix();
        matrix.setValues(new float[]{1.0f, 0.0f, dx, 0.0f, 1.0f, dy, 0.0f, 0.0f, 1.0f});
        Matrix current = new Matrix();
        current.setValues(this.MATRIX);
        matrix.preConcat(current);
        this.set(matrix);
    }

    public void postScale(float sx, float sy) {
        Matrix matrix = new Matrix();
        matrix.setValues(new float[]{sx, 0.0f, 0.0f, 0.0f, sy, 0.0f, 0.0f, 0.0f, 1.0f});
        Matrix current = new Matrix();
        current.setValues(this.MATRIX);
        matrix.preConcat(current);
        this.set(matrix);
    }

    public void postRotate(float degrees, float px, float py) {
        double radians = Math.toRadians(degrees);
        float sin = (float)Math.sin(radians);
        float cos = (float)Math.cos(radians);
        Matrix matrix = new Matrix();
        matrix.setValues(new float[]{cos, -sin, -px * cos + py * sin + px, sin, cos, -px * sin - py * cos + py, 0.0f, 0.0f, 1.0f});
        Matrix current = new Matrix();
        current.setValues(this.MATRIX);
        matrix.preConcat(current);
        this.set(matrix);
    }

    public void setTranslate(float dx, float dy) {
        Matrix matrix = new Matrix();
        matrix.setValues(new float[]{1.0f, 0.0f, dx, 0.0f, 1.0f, dy, 0.0f, 0.0f, 1.0f});
        matrix.getValues(this.MATRIX);
    }

    public void setRotate(float degrees, float px, float py) {
        Matrix matrix = new Matrix();
        double radians = Math.toRadians(degrees);
        float sin = (float)Math.sin(radians);
        float cos = (float)Math.cos(radians);
        matrix.setValues(new float[]{cos, -sin, -px * cos + py * sin + px, sin, cos, -px * sin - py * cos + py, 0.0f, 0.0f, 1.0f});
        matrix.getValues(this.MATRIX);
    }

    public void setScale(float sx, float sy) {
        Matrix matrix = new Matrix();
        matrix.setValues(new float[]{sx, 0.0f, 0.0f, 0.0f, sy, 0.0f, 0.0f, 0.0f, 1.0f});
        matrix.getValues(this.MATRIX);
    }

    public void mapVectors(float[] vecs) {
        if (vecs == null || vecs.length % 2 != 0) {
            return;
        }
        for (int i = 0; i < vecs.length / 2; ++i) {
            float[] result = this.mapVector(vecs[i * 2], vecs[i * 2 + 1]);
            vecs[i * 2] = result[0];
            vecs[i * 2 + 1] = result[1];
        }
    }

    public float[] mapVector(float x, float y) {
        float[] result = new float[]{x, y};
        result[0] = this.MATRIX[0] * x + this.MATRIX[1] * y;
        result[1] = this.MATRIX[3] * x + this.MATRIX[4] * y;
        return result;
    }

    public void getValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        values[0] = this.MATRIX[0];
        values[1] = this.MATRIX[1];
        values[2] = this.MATRIX[2];
        values[3] = this.MATRIX[3];
        values[4] = this.MATRIX[4];
        values[5] = this.MATRIX[5];
        values[6] = this.MATRIX[6];
        values[7] = this.MATRIX[7];
        values[8] = this.MATRIX[8];
    }

    public void setValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.MATRIX[0] = values[0];
        this.MATRIX[1] = values[1];
        this.MATRIX[2] = values[2];
        this.MATRIX[3] = values[3];
        this.MATRIX[4] = values[4];
        this.MATRIX[5] = values[5];
        this.MATRIX[6] = values[6];
        this.MATRIX[7] = values[7];
        this.MATRIX[8] = values[8];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Matrix{");
        this.toShortString(sb);
        sb.append('}');
        return sb.toString();
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder(64);
        this.toShortString(sb);
        return sb.toString();
    }

    public void toShortString(StringBuilder sb) {
        float[] values = new float[9];
        this.getValues(values);
        sb.append('[');
        sb.append(values[0]);
        sb.append(", ");
        sb.append(values[1]);
        sb.append(", ");
        sb.append(values[2]);
        sb.append("][");
        sb.append(values[3]);
        sb.append(", ");
        sb.append(values[4]);
        sb.append(", ");
        sb.append(values[5]);
        sb.append("][");
        sb.append(values[6]);
        sb.append(", ");
        sb.append(values[7]);
        sb.append(", ");
        sb.append(values[8]);
        sb.append(']');
    }

    public void printShortString(PrintWriter pw) {
        float[] values = new float[9];
        this.getValues(values);
        pw.print('[');
        pw.print(values[0]);
        pw.print(", ");
        pw.print(values[1]);
        pw.print(", ");
        pw.print(values[2]);
        pw.print("][");
        pw.print(values[3]);
        pw.print(", ");
        pw.print(values[4]);
        pw.print(", ");
        pw.print(values[5]);
        pw.print("][");
        pw.print(values[6]);
        pw.print(", ");
        pw.print(values[7]);
        pw.print(", ");
        pw.print(values[8]);
        pw.print(']');
    }
}

