/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.utils;

import com.github.megatronking.svg.generator.utils.SCU;

public class Dimen {
    private static final float DEFAULT_VALUE = 0.0f;
    private static final String UNIT1 = "dp";
    private static final String UNIT2 = "dip";
    private static final String UNIT3 = "px";

    public static float convert(String value) {
        if (value == null) {
            return 0.0f;
        }
        float tryFloat = SCU.parseFloat(value, -1.0f);
        if (tryFloat != -1.0f) {
            return tryFloat;
        }
        if (value.endsWith(UNIT1)) {
            return SCU.parseFloat(value.substring(0, value.indexOf(UNIT1)), 0.0f);
        }
        if (value.endsWith(UNIT2)) {
            return SCU.parseFloat(value.substring(0, value.indexOf(UNIT2)), 0.0f);
        }
        if (value.endsWith(UNIT3)) {
            return SCU.parseFloat(value.substring(0, value.indexOf(UNIT3)), 0.0f);
        }
        return 0.0f;
    }

    public static boolean isDip(String value) {
        return value != null && (value.endsWith(UNIT1) || value.endsWith(UNIT2));
    }

    public static boolean isPx(String value) {
        return value != null && value.endsWith(UNIT3);
    }
}

