/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.utils;

import com.github.megatronking.svg.generator.utils.KeywordColors;
import java.lang.reflect.Field;
import java.util.HashMap;

public class Color {
    public static final int BLACK = -16777216;
    public static final int DKGRAY = -12303292;
    public static final int GRAY = -7829368;
    public static final int LTGRAY = -3355444;
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int YELLOW = -256;
    public static final int CYAN = -16711681;
    public static final int MAGENTA = -65281;
    public static final int SHADOW = -870178270;
    public static final int TRANSPARENT = 0;
    private static final int DEFAULT_COLOR = 0;
    private static final String PREFIX = "#";
    private static final String REFERENCE_SYSTEM = "@android:color/";
    private static final String REFERENCE_APP = "@color/";
    private static final String REFERENCE_RGB = "rgb";
    public static HashMap<String, Integer> appColorMaps = new HashMap();
    public static HashMap<String, Integer> systemColorMaps = new HashMap();
    public static HashMap<String, Integer> keywordColorMaps = new HashMap();

    public static int convert(String color) {
        return Color.convert(color, 0);
    }

    public static int convert(String color, int defaultColor) {
        if (color == null) {
            return defaultColor;
        }
        if (color.startsWith(PREFIX)) {
            return Color.parseColor(color, defaultColor);
        }
        if (color.startsWith(REFERENCE_SYSTEM)) {
            return Color.referenceSystem(color);
        }
        if (color.startsWith(REFERENCE_APP)) {
            return Color.referenceApp(color);
        }
        if (color.startsWith(REFERENCE_RGB)) {
            return Color.convertRGBToInteger(color);
        }
        if (keywordColorMaps.containsKey(color)) {
            return keywordColorMaps.get(color);
        }
        return defaultColor;
    }

    private static int referenceSystem(String color) {
        String name = color.substring(REFERENCE_SYSTEM.length());
        return systemColorMaps.containsKey(name) ? systemColorMaps.get(name) : 0;
    }

    private static int referenceApp(String color) {
        String name = color.substring(REFERENCE_APP.length());
        return appColorMaps.containsKey(name) ? appColorMaps.get(name) : 0;
    }

    private static int parseColor(String colorString, int defaultColor) {
        long color = Long.parseLong(colorString.substring(1), 16);
        if (colorString.length() == 7) {
            color |= 0xFFFFFFFFFF000000L;
        } else if (colorString.length() == 4) {
            String newColorString = "0xff";
            for (int i = 0; i < colorString.length() - 1; ++i) {
                newColorString = newColorString + colorString.charAt(i);
                newColorString = newColorString + colorString.charAt(i);
            }
            color = Long.parseLong(newColorString, 16);
        } else if (colorString.length() != 9) {
            return defaultColor;
        }
        return (int)color;
    }

    private static int convertRGBToInteger(String svgValue) {
        String functionValue = svgValue.trim();
        String[] numbers = (functionValue = svgValue.substring(4, functionValue.length() - 1)).split(",");
        if (numbers.length != 3) {
            return -16777216;
        }
        int[] color = new int[3];
        for (int i = 0; i < 3; ++i) {
            String number = numbers[i];
            if ((number = number.trim()).endsWith("%")) {
                float value = Float.parseFloat(number.substring(0, number.length() - 1));
                color[i] = Color.clamp((int)(value * 255.0f / 100.0f), 0, 255);
                continue;
            }
            int value = Integer.parseInt(number);
            color[i] = Color.clamp(value, 0, 255);
        }
        StringBuilder builder = new StringBuilder("FF");
        for (int i = 0; i < 3; ++i) {
            builder.append(String.format("%02X", color[i]));
        }
        String result = builder.toString();
        return Integer.parseUnsignedInt(result, 16);
    }

    private static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    static {
        systemColorMaps.put("white", -1);
        systemColorMaps.put("black", -16777216);
        systemColorMaps.put("dkgray", -12303292);
        systemColorMaps.put("gray", -7829368);
        systemColorMaps.put("ltgray", -3355444);
        systemColorMaps.put("red", -65536);
        systemColorMaps.put("green", -16711936);
        systemColorMaps.put("blue", -16776961);
        systemColorMaps.put("yellow", -256);
        systemColorMaps.put("cyan", -16711681);
        systemColorMaps.put("magenta", -65281);
        systemColorMaps.put("transparent", 0);
        systemColorMaps.put("shadow", -870178270);
        systemColorMaps.put("none", 0);
        try {
            Field[] fields;
            for (Field field : fields = KeywordColors.class.getDeclaredFields()) {
                field.setAccessible(true);
                keywordColorMaps.put(field.getName(), (Integer)field.get(null));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

