/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.svg.utils;

import com.github.megatronking.svg.generator.svg.css.CSSParser;
import com.github.megatronking.svg.generator.svg.css.CSSParserCallback;
import com.github.megatronking.svg.generator.utils.TextUtils;
import java.util.HashMap;
import java.util.Map;

public class StyleUtils {
    public static Map<String, String> convertStyleString2Map(String style) {
        String[] styleParts;
        if (TextUtils.isEmpty(style)) {
            return null;
        }
        HashMap<String, String> styleMaps = new HashMap<String, String>();
        for (String stylePart : styleParts = style.split(";")) {
            String[] nameValue = stylePart.split(":");
            if (nameValue.length != 2) continue;
            styleMaps.put(nameValue[0].trim(), nameValue[1].trim());
        }
        return styleMaps;
    }

    public static void fill2Map(String cssStyle, Map<String, Map<String, String>> map) {
        if (TextUtils.isEmpty(cssStyle) || map == null) {
            return;
        }
        CSSParser cssParser = new CSSParser();
        try {
            cssParser.parse(cssStyle, new CSSParserCallbackImpl(map), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class CSSParserCallbackImpl
    implements CSSParserCallback {
        private Map<String, Map<String, String>> map;
        private Map<String, String> styleMap;
        private boolean isInRule;
        private String propertySave;

        private CSSParserCallbackImpl(Map<String, Map<String, String>> map) {
            this.map = map;
        }

        @Override
        public void handleImport(String importString) {
        }

        @Override
        public void handleSelector(String selector) {
            if (!TextUtils.isEmpty(selector) && !this.isInRule) {
                this.styleMap = new HashMap<String, String>();
                this.map.put(selector, this.styleMap);
            } else {
                this.styleMap = null;
            }
            this.propertySave = null;
        }

        @Override
        public void startRule() {
            this.isInRule = true;
            this.propertySave = null;
        }

        @Override
        public void handleProperty(String property) {
            if (!TextUtils.isEmpty(property) && this.isInRule && this.styleMap != null && this.propertySave == null) {
                this.propertySave = property.trim();
            }
        }

        @Override
        public void handleValue(String value) {
            if (!TextUtils.isEmpty(value) && this.isInRule && this.styleMap != null && this.propertySave != null) {
                this.styleMap.put(this.propertySave, value.trim());
                this.propertySave = null;
            }
        }

        @Override
        public void endRule() {
            this.isInRule = false;
            this.styleMap = null;
            this.propertySave = null;
        }
    }
}

