/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.svg.parser.attribute;

import com.github.megatronking.svg.generator.svg.model.Symbol;
import com.github.megatronking.svg.generator.svg.parser.SvgNodeAbstractAttributeParser;
import com.github.megatronking.svg.generator.utils.SCU;
import com.github.megatronking.svg.generator.utils.TextUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class SymbolAttributeParser
extends SvgNodeAbstractAttributeParser<Symbol> {
    @Override
    public void parse(Element element, Symbol symbol) throws DocumentException {
        super.parse(element, symbol);
        String viewBox = this.parseString(element, "viewBox", null);
        if (viewBox == null) {
            viewBox = this.parseString(element, "viewbox", null);
        }
        if (viewBox == null) {
            viewBox = this.parseString(element, "viewPort", null);
        }
        if (viewBox == null) {
            viewBox = this.parseString(element, "viewport", null);
        }
        if (viewBox != null) {
            viewBox = TextUtils.removeMultiSpace(viewBox);
            String[] viewBoxValues = viewBox.trim().split(" ");
            symbol.viewBox = new float[4];
            for (int i = 0; i < viewBoxValues.length; ++i) {
                symbol.viewBox[i] = SCU.parseFloat(viewBoxValues[i], 0.0f);
            }
        } else {
            symbol.viewBox = new float[4];
        }
    }
}

