/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.svg.parser.attribute;

import com.github.megatronking.svg.generator.svg.model.Svg;
import com.github.megatronking.svg.generator.svg.parser.SvgNodeAbstractAttributeParser;
import com.github.megatronking.svg.generator.utils.SCU;
import com.github.megatronking.svg.generator.utils.TextUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class SvgAttributeParser
extends SvgNodeAbstractAttributeParser<Svg> {
    @Override
    public void parse(Element element, Svg svg) throws DocumentException {
        super.parse(element, svg);
        svg.w = this.parseDimen(element, "width");
        svg.h = this.parseDimen(element, "height");
        String viewBox = this.parseString(element, "viewBox", null);
        if (viewBox == null) {
            viewBox = this.parseString(element, "viewbox", null);
        }
        if (viewBox == null) {
            viewBox = this.parseString(element, "viewPort", null);
        }
        if (viewBox == null) {
            viewBox = this.parseString(element, "viewport", null);
        }
        if (viewBox != null) {
            viewBox = TextUtils.removeMultiSpace(viewBox);
            String[] viewBoxValues = viewBox.trim().split(" ");
            svg.viewBox = new float[4];
            for (int i = 0; i < viewBoxValues.length; ++i) {
                svg.viewBox[i] = SCU.parseFloat(viewBoxValues[i], 0.0f);
            }
        } else {
            svg.viewBox = new float[4];
        }
        if (svg.w != 0.0f) {
            svg.viewBox[2] = svg.w;
        } else {
            svg.w = svg.viewBox[2];
        }
        if (svg.h != 0.0f) {
            svg.viewBox[3] = svg.h;
        } else {
            svg.h = svg.viewBox[3];
        }
    }
}

