/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.svg.parser;

import com.github.megatronking.svg.generator.svg.model.SvgNode;
import com.github.megatronking.svg.generator.svg.utils.StyleUtils;
import com.github.megatronking.svg.generator.svg.utils.TransformUtils;
import com.github.megatronking.svg.generator.utils.SCU;
import com.github.megatronking.svg.generator.xml.CommonAbstractAttributeParser;
import java.util.HashMap;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public abstract class SvgNodeAbstractAttributeParser<T extends SvgNode>
extends CommonAbstractAttributeParser<T> {
    @Override
    public void parse(Element element, T node) throws DocumentException {
        this.handleCommonAttributes(element, (SvgNode)node);
    }

    private void handleCommonAttributes(Element element, SvgNode node) {
        String fillRule;
        String fillOpacity;
        String fillColor;
        String strokeOpacity;
        String strokeMiterLimit;
        String strokeLineCap;
        String strokeLineJoin;
        String strokeColor;
        String strokeWidth;
        String display;
        node.id = this.parseString(element, "id");
        node.clazz = this.parseString(element, "class");
        String matrix = this.parseString(element, "transform");
        if (matrix != null) {
            if (matrix.startsWith("matrix")) {
                node.matrix = new float[6];
                node.matrix[0] = 1.0f;
                node.matrix[3] = 1.0f;
                String[] matrixValues = matrix.substring("matrix(".length(), matrix.length() - 1).split(",");
                for (int i = 0; i < matrixValues.length; ++i) {
                    node.matrix[i] = SCU.parseFloat(matrixValues[i].trim(), node.matrix[i]);
                }
            } else {
                node.matrix = TransformUtils.formatTransform(matrix);
            }
        }
        node.styleMaps = StyleUtils.convertStyleString2Map(this.parseString(element, "style"));
        if (node.styleMaps == null) {
            node.styleMaps = new HashMap<String, String>();
        }
        if ((display = this.parseString(element, "display")) != null) {
            node.styleMaps.put("display", display.trim());
        }
        if ((strokeWidth = this.parseString(element, "stroke-width")) != null) {
            node.styleMaps.put("stroke-width", strokeWidth);
        }
        if ((strokeColor = this.parseString(element, "stroke")) != null) {
            node.styleMaps.put("stroke", strokeColor);
        }
        if ((strokeLineJoin = this.parseString(element, "stroke-linejoin")) != null) {
            node.styleMaps.put("stroke-linejoin", strokeLineJoin.trim());
        }
        if ((strokeLineCap = this.parseString(element, "stroke-linecap")) != null) {
            node.styleMaps.put("stroke-linecap", strokeLineCap.trim());
        }
        if ((strokeMiterLimit = this.parseString(element, "stroke-miterlimit")) != null) {
            node.styleMaps.put("stroke-miterlimit", strokeMiterLimit);
        }
        if ((strokeOpacity = this.parseString(element, "stroke-opacity")) != null) {
            node.styleMaps.put("stroke-opacity", strokeOpacity);
        }
        if ((fillColor = this.parseString(element, "fill")) != null) {
            node.styleMaps.put("fill", fillColor);
        }
        if ((fillOpacity = this.parseString(element, "fill-opacity")) != null) {
            node.styleMaps.put("fill-opacity", fillOpacity);
        }
        if ((fillRule = this.parseString(element, "fill-rule")) != null) {
            node.styleMaps.put("fill-rule", fillRule.trim());
        }
    }
}

