/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.svg.model;

import com.github.megatronking.svg.generator.svg.utils.TransformUtils;
import com.github.megatronking.svg.generator.utils.Color;
import com.github.megatronking.svg.generator.utils.Dimen;
import com.github.megatronking.svg.generator.utils.FloatUtils;
import com.github.megatronking.svg.generator.utils.PathDataNode;
import com.github.megatronking.svg.generator.utils.SCU;
import java.util.HashMap;
import java.util.Map;

public abstract class SvgNode
implements Cloneable {
    public String id;
    public String clazz;
    protected String pathData;
    public Map<String, String> styleMaps;
    public float[] matrix;

    public abstract void toPath();

    public void applyStyles(Map<String, String> inheritStyles, Map<String, Map<String, String>> defineStyles) {
        if (this.styleMaps == null) {
            this.styleMaps = new HashMap<String, String>();
        }
        for (String key : this.styleMaps.keySet()) {
            String value = this.styleMaps.get(key).trim();
            if (!"inherit".equals(value)) continue;
            this.styleMaps.remove(key);
        }
        String nodeName = this.getClass().getSimpleName().toLowerCase();
        this.applyDefineStylesByRef(nodeName, defineStyles);
        if (this.clazz != null) {
            this.applyDefineStylesByRef("." + this.clazz, defineStyles);
            this.applyDefineStylesByRef(nodeName + "." + this.clazz, defineStyles);
        }
        if (this.id != null) {
            this.applyDefineStylesByRef("#" + this.id, defineStyles);
            this.applyDefineStylesByRef(nodeName + "#" + this.id, defineStyles);
        }
        if (inheritStyles != null && !inheritStyles.isEmpty()) {
            for (String key : inheritStyles.keySet()) {
                if (this.styleMaps.containsKey(key)) continue;
                this.styleMaps.put(key, inheritStyles.get(key));
            }
        }
    }

    private void applyDefineStylesByRef(String refName, Map<String, Map<String, String>> defineStyles) {
        Map<String, String> defineStylesByRefNames;
        if (defineStyles != null && !defineStyles.isEmpty() && defineStyles.containsKey(refName) && (defineStylesByRefNames = defineStyles.get(refName)) != null && !defineStylesByRefNames.isEmpty()) {
            for (String styleName : defineStylesByRefNames.keySet()) {
                if (this.styleMaps.containsKey(styleName)) continue;
                this.styleMaps.put(styleName, defineStylesByRefNames.get(styleName));
            }
        }
    }

    public void transform(float a, float b, float c, float d, float e, float f) {
        if (!this.isValid()) {
            return;
        }
        this.matrix = TransformUtils.preConcat(this.matrix, new float[]{a, b, c, d, e, f});
        if (this.pathData == null) {
            return;
        }
        PathDataNode[] node = PathDataNode.createNodesFromPathData(this.pathData);
        if (node == null) {
            return;
        }
        if (this.matrix[0] != 1.0f || this.matrix[1] != 0.0f || this.matrix[2] != 0.0f || this.matrix[3] != 1.0f || this.matrix[4] != 0.0f || this.matrix[5] != 0.0f) {
            PathDataNode.transform(this.matrix[0], this.matrix[1], this.matrix[2], this.matrix[3], this.matrix[4], this.matrix[5], node);
        }
        this.pathData = PathDataNode.nodeListToString(node);
    }

    public boolean isValid() {
        return this.pathData != null && this.somethingToDraw();
    }

    private boolean somethingToDraw() {
        if (this.styleMaps == null) {
            this.styleMaps = new HashMap<String, String>();
        }
        if ("0".equals(this.styleMaps.get("opacity"))) {
            return false;
        }
        if ("none".equals(this.styleMaps.get("display"))) {
            return false;
        }
        int fillColor = this.styleMaps.containsKey("fill") ? Color.convert(this.styleMaps.get("fill")) : -16777216;
        float fillOpacity = this.styleMaps.containsKey("fill-opacity") ? SCU.parseFloat(this.styleMaps.get("fill-opacity"), 1.0f) : 1.0f;
        boolean emptyFill = fillColor == 0 || fillOpacity == 0.0f;
        int strokeColor = Color.convert(this.styleMaps.get("stroke"));
        float strokeWidth = Dimen.convert(this.styleMaps.get("stroke-width"));
        if (strokeColor != 0 && strokeWidth == 0.0f) {
            strokeWidth = 1.0f;
        }
        float strokeOpacity = this.styleMaps.containsKey("stroke-opacity") ? SCU.parseFloat(this.styleMaps.get("stroke-opacity"), 1.0f) : 1.0f;
        boolean emptyStroke = strokeColor == 0 || strokeWidth <= 0.0f || strokeOpacity == 0.0f;
        return !emptyFill || !emptyStroke;
    }

    public String convert2VectorXml(String indent) {
        String fillRule;
        float fillOpacityAsFloat;
        String fillOpacity;
        int fillColor;
        StringBuilder sb = new StringBuilder();
        sb.append("<path\n");
        if (this.id != null && this.id.length() != 0) {
            sb.append(indent).append("    android:name=\"").append(this.id).append("\"\n");
        }
        int n = fillColor = this.styleMaps != null && this.styleMaps.containsKey("fill") ? Color.convert(this.styleMaps.get("fill")) : -16777216;
        if (fillColor != 0) {
            sb.append(indent).append("    android:fillColor=\"#").append(Integer.toHexString(fillColor)).append("\"\n");
        }
        if ((fillOpacity = this.styleMaps.get("fill-opacity")) != null && (fillOpacityAsFloat = SCU.parseFloat(fillOpacity, 1.0f)) != 0.0f) {
            sb.append(indent).append("    android:fillAlpha=\"").append(fillOpacityAsFloat).append("\"\n");
        }
        if ((fillRule = this.styleMaps.get("fill-rule")) != null && !"inherit".equals(fillRule)) {
            if ("evenodd".equals(fillRule)) {
                fillRule = "evenOdd";
            }
            if ("nonzero".equals(fillRule)) {
                fillRule = "nonZero";
            }
            sb.append(indent).append("    android:fillType=\"").append(fillRule).append("\"\n");
        }
        if (this.styleMaps != null) {
            float strokeOpacityAsFloat;
            String strokeOpacity;
            String strokeMiterLimit;
            String strokeLineCap;
            String strokeLineJoin;
            int strokeColor = Color.convert(this.styleMaps.get("stroke"));
            float strokeWidth = Dimen.convert(this.styleMaps.get("stroke-width"));
            if (strokeColor != 0) {
                if (strokeWidth == 0.0f) {
                    strokeWidth = 1.0f;
                }
                sb.append(indent).append("    android:strokeColor=\"#").append(Integer.toHexString(strokeColor)).append("\"\n");
                sb.append(indent).append("    android:strokeWidth=\"").append(FloatUtils.format2String(strokeWidth)).append("\"\n");
            }
            if ((strokeLineJoin = this.styleMaps.get("stroke-linejoin")) != null && !"inherit".equals(strokeLineJoin)) {
                sb.append(indent).append("    android:strokeLineJoin=\"").append(strokeLineJoin).append("\"\n");
            }
            if ((strokeLineCap = this.styleMaps.get("stroke-linecap")) != null && !"inherit".equals(strokeLineCap)) {
                sb.append(indent).append("    android:strokeLineCap=\"").append(strokeLineCap).append("\"\n");
            }
            if ((strokeMiterLimit = this.styleMaps.get("stroke-miterlimit")) != null) {
                float strokeMiterLimitAsFloat = SCU.parseFloat(strokeMiterLimit, 4.0f);
                if (!"inherit".equals(strokeMiterLimit) && strokeMiterLimitAsFloat >= 1.0f) {
                    sb.append(indent).append("    android:strokeMiterLimit=\"").append(strokeMiterLimitAsFloat).append("\"\n");
                }
            }
            if ((strokeOpacity = this.styleMaps.get("stroke-opacity")) != null && (strokeOpacityAsFloat = SCU.parseFloat(strokeOpacity, 1.0f)) != 0.0f) {
                sb.append(indent).append("    android:strokeAlpha=\"").append(strokeOpacityAsFloat).append("\"\n");
            }
        }
        sb.append(indent).append("    android:pathData=\"").append(this.pathData).append("\"/>\n");
        return sb.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        SvgNode newNode = (SvgNode)super.clone();
        if (newNode != null && this.styleMaps != null) {
            newNode.styleMaps = new HashMap<String, String>(this.styleMaps);
        }
        return newNode;
    }
}

