/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.svg.model;

import com.github.megatronking.svg.generator.svg.model.Style;
import com.github.megatronking.svg.generator.svg.model.SvgGroupNode;
import com.github.megatronking.svg.generator.svg.model.SvgNode;
import com.github.megatronking.svg.generator.svg.model.Symbol;
import com.github.megatronking.svg.generator.svg.model.Use;
import com.github.megatronking.svg.generator.utils.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Svg
extends SvgGroupNode {
    public float w;
    public float h;
    public float[] viewBox;

    @Override
    public void transform(float a, float b, float c, float d, float e, float f) {
        for (SvgNode svgNode : this.children) {
            this.transform(svgNode);
        }
    }

    private void transform(SvgNode node) {
        if (this.matrix != null) {
            node.transform(this.matrix[0], this.matrix[1], this.matrix[2], this.matrix[3], this.matrix[4], this.matrix[5]);
        }
        if (this.viewBox != null) {
            node.transform(1.0f, 0.0f, 0.0f, 1.0f, -this.viewBox[0], -this.viewBox[1]);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public void parseEnd() {
        HashMap<String, Map<String, String>> defineStyles = new HashMap<String, Map<String, String>>();
        for (Style style : this.findAllStylesFromSvg()) {
            defineStyles.putAll(style.toStyle());
        }
        this.replaceUseTagWithHrefLink(this.children);
        this.applyStyles(null, defineStyles);
        this.transform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    private List<Style> findAllStylesFromSvg() {
        ArrayList<Style> allStyles = new ArrayList<Style>();
        this.recursiveFindStyles(this.children, allStyles);
        return allStyles;
    }

    private void recursiveFindStyles(List<SvgNode> nodes, List<Style> styles) {
        if (nodes == null || nodes.isEmpty() || styles == null) {
            return;
        }
        for (SvgNode svgNode : nodes) {
            if (svgNode instanceof Style) {
                styles.add((Style)svgNode);
                continue;
            }
            if (!(svgNode instanceof SvgGroupNode)) continue;
            this.recursiveFindStyles(((SvgGroupNode)svgNode).children, styles);
        }
    }

    private void replaceUseTagWithHrefLink(List<SvgNode> nodes) {
        if (nodes == null) {
            return;
        }
        for (SvgNode svgNode : nodes) {
            if (svgNode instanceof Use) {
                SvgNode clone;
                List<SvgNode> hrefNodes;
                if (TextUtils.isEmpty(((Use)svgNode).href) || !((Use)svgNode).href.startsWith("#") || (hrefNodes = this.findNodesById(((Use)svgNode).href.substring(1))) == null || hrefNodes.isEmpty() || (clone = this.cloneNode(hrefNodes.get(0))) == null) continue;
                if (clone instanceof Symbol) {
                    ((Symbol)clone).isInUse = true;
                }
                ((Use)svgNode).children.add(clone);
                continue;
            }
            if (!(svgNode instanceof SvgGroupNode)) continue;
            this.replaceUseTagWithHrefLink(((SvgGroupNode)svgNode).children);
        }
    }

    private List<SvgNode> findNodesById(String id) {
        ArrayList<SvgNode> resultNodes = new ArrayList<SvgNode>();
        this.recursiveFindNodesById(id, this.children, resultNodes);
        return resultNodes;
    }

    private void recursiveFindNodesById(String clazz, List<SvgNode> nodes, List<SvgNode> resultNodes) {
        if (nodes == null || nodes.isEmpty() || resultNodes == null) {
            return;
        }
        for (SvgNode svgNode : nodes) {
            if (!TextUtils.isEmpty(svgNode.id) && svgNode.id.equals(clazz)) {
                resultNodes.add(svgNode);
                continue;
            }
            if (!(svgNode instanceof SvgGroupNode)) continue;
            this.recursiveFindNodesById(clazz, ((SvgGroupNode)svgNode).children, resultNodes);
        }
    }

    private SvgNode cloneNode(SvgNode node) {
        try {
            return (SvgNode)node.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

