/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.svg;

import com.github.megatronking.svg.generator.svg.SvgParseException;
import com.github.megatronking.svg.generator.svg.model.Svg;
import com.github.megatronking.svg.generator.svg.parser.SvgParserImpl;
import com.github.megatronking.svg.generator.xml.SimpleImplementSAXReader;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class SvgSAXReader
extends SimpleImplementSAXReader<Svg> {
    @Override
    protected Svg parseDocument(Document document) throws DocumentException {
        Element svgElement = document.getRootElement();
        if (!"svg".equals(svgElement.getName())) {
            throw new SvgParseException("The root element must be svg");
        }
        List childElements = svgElement.elements();
        if (childElements == null || childElements.isEmpty()) {
            throw new SvgParseException("There is no child node in the svg");
        }
        Svg svg = new Svg();
        SvgParserImpl.SVG_ELEMENT_PARSER.parse(svgElement, svg);
        return svg;
    }
}

