/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.svg;

import com.github.megatronking.svg.generator.svg.SvgSAXReader;
import com.github.megatronking.svg.generator.svg.model.Svg;
import com.github.megatronking.svg.generator.writer.impl.Svg2VectorTemplateWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.dom4j.DocumentException;

public class Svg2Vector {
    public static String parseSvgToXml(File inputSVG, File outputVector, int width, int height) {
        if (inputSVG == null || outputVector == null) {
            return "Invalid input params!";
        }
        if (!inputSVG.exists() || inputSVG.length() == 0L || inputSVG.isDirectory()) {
            return "Invalid svg file: " + inputSVG.getName();
        }
        SvgSAXReader reader = new SvgSAXReader();
        try {
            Svg svg = (Svg)reader.read(inputSVG);
            if (width > 0) {
                svg.w = width;
            }
            if (height > 0) {
                svg.h = height;
            }
            Svg2VectorTemplateWriter writer = new Svg2VectorTemplateWriter(svg);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(outputVector));
            writer.write(bufferedWriter);
        }
        catch (IOException | DocumentException e) {
            return "Exception in parsing " + inputSVG.getName() + ":\n" + e.getMessage();
        }
        return null;
    }

    public static String parseSvgToXml(File inputSVG, OutputStream outputStream, int width, int height) {
        if (inputSVG == null || outputStream == null) {
            return "Invalid input params!";
        }
        if (!inputSVG.exists() || inputSVG.length() == 0L || inputSVG.isDirectory()) {
            return "Invalid svg file: " + inputSVG.getName();
        }
        SvgSAXReader reader = new SvgSAXReader();
        try {
            Svg svg = (Svg)reader.read(inputSVG);
            if (width > 0) {
                svg.w = width;
            }
            if (height > 0) {
                svg.h = height;
            }
            Svg2VectorTemplateWriter writer = new Svg2VectorTemplateWriter(svg);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            writer.write(bufferedWriter);
        }
        catch (IOException | DocumentException e) {
            return "Exception in parsing " + inputSVG.getName() + ":\n" + e.getMessage();
        }
        return null;
    }

    public static String parseSvgToXml(InputStream inputStream, OutputStream outputStream, int width, int height) {
        if (inputStream == null || outputStream == null) {
            return "Invalid input params!";
        }
        SvgSAXReader reader = new SvgSAXReader();
        try {
            Svg svg = (Svg)reader.read(inputStream);
            if (width > 0) {
                svg.w = width;
            }
            if (height > 0) {
                svg.h = height;
            }
            Svg2VectorTemplateWriter writer = new Svg2VectorTemplateWriter(svg);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            writer.write(bufferedWriter);
        }
        catch (IOException | DocumentException e) {
            return "Exception when parsing :\n" + e.getMessage();
        }
        return null;
    }
}

