/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.render;

import com.github.megatronking.svg.generator.render.NotifyVectorRenderer;
import com.github.megatronking.svg.generator.vector.model.Group;
import com.github.megatronking.svg.generator.vector.model.Path;
import com.github.megatronking.svg.generator.vector.model.Vector;
import java.util.List;

public class VectorRootRenderer
extends NotifyVectorRenderer<Vector> {
    @Override
    public void render(Vector vector) {
        this.notifyResult("final float scaleX = w / " + vector.viewportWidth + "f;");
        this.notifyResult("final float scaleY = h / " + vector.viewportHeight + "f;");
        if (this.hasPathNeedMinScale(vector.children)) {
            this.notifyResult("final float minScale = Math.min(scaleX, scaleY);");
        }
        this.writeNewLine();
    }

    @Override
    protected void notifyResult(String result) {
        super.notifyResult("        " + result + "\n");
    }

    private boolean hasPathNeedMinScale(List<Object> children) {
        if (children != null && !children.isEmpty()) {
            for (Object child : children) {
                if (!(child instanceof Path ? ((Path)child).strokeColor != 0 : this.hasPathNeedMinScale(((Group)child).children))) continue;
                return true;
            }
        }
        return false;
    }
}

