/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.render;

import com.github.megatronking.svg.generator.render.IVectorRenderer;
import com.github.megatronking.svg.generator.render.NotifyVectorRenderer;
import com.github.megatronking.svg.generator.render.VectorPathRenderer;
import com.github.megatronking.svg.generator.render.VectorRootRenderer;
import com.github.megatronking.svg.generator.vector.model.Group;
import com.github.megatronking.svg.generator.vector.model.Path;
import com.github.megatronking.svg.generator.vector.model.Vector;

public class VectorRenderer
implements IVectorRenderer<Vector>,
NotifyVectorRenderer.VectorRendererListener {
    private VectorRootRenderer mRootRenderer = new VectorRootRenderer();
    private VectorPathRenderer mPathRenderer;
    private StringBuilder mRenderResult;

    public VectorRenderer() {
        this.mRootRenderer.setVectorRendererListener(this);
        this.mPathRenderer = new VectorPathRenderer();
        this.mPathRenderer.setVectorRendererListener(this);
        this.mRenderResult = new StringBuilder();
    }

    @Override
    public void render(Vector vector) {
        this.mRootRenderer.render(vector);
        for (Object child : vector.children) {
            this.renderChild(child);
        }
    }

    private void renderChild(Object object) {
        if (object instanceof Path) {
            this.mPathRenderer.render((Path)object);
        } else if (object instanceof Group) {
            for (Object child : ((Group)object).children) {
                this.renderChild(child);
            }
        }
    }

    @Override
    public void receiveResult(String result) {
        this.mRenderResult.append(result);
    }

    public String renderResult() {
        return this.mRenderResult.toString();
    }
}

