/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.svg.generator.render;

import com.github.megatronking.svg.generator.render.NotifyVectorRenderer;
import com.github.megatronking.svg.generator.utils.Matrix;
import com.github.megatronking.svg.generator.utils.PathDataNode;
import com.github.megatronking.svg.generator.vector.model.ClipPath;
import com.github.megatronking.svg.generator.vector.model.Path;

public class VectorPathRenderer
extends NotifyVectorRenderer<Path> {
    private boolean isFillPaintInited;
    private boolean isStrokePaintInited;

    @Override
    public void render(Path path) {
        super.render(path);
        if (path.fillColor == 0 && path.strokeColor == 0) {
            return;
        }
        float[] matrixValues = new float[9];
        Matrix groupStackedMatrix = path.parentGroup.getMatrix();
        groupStackedMatrix.getValues(matrixValues);
        float matrixScale = this.getMatrixScale(groupStackedMatrix);
        if (matrixScale == 0.0f) {
            return;
        }
        this.resetPaths();
        this.writeNewLine();
        this.initFinalPathMatrix(matrixValues);
        this.writeNewLine();
        this.drawPathData(path.pathData);
        this.writeNewLine();
        if (path instanceof ClipPath) {
            this.drawClipPath();
        } else {
            this.drawPath(path, matrixScale);
        }
    }

    @Override
    protected void notifyResult(String result) {
        super.notifyResult("        " + result + "\n");
    }

    private void resetPaths() {
        this.notifyResult("mPath.reset();");
        this.notifyResult("mRenderPath.reset();");
    }

    private void initFinalPathMatrix(float[] matrixValues) {
        this.notifyResult("mFinalPathMatrix.setValues(new float[]{" + matrixValues[0] + "f, " + matrixValues[1] + "f, " + matrixValues[2] + "f, " + matrixValues[3] + "f, " + matrixValues[4] + "f, " + matrixValues[5] + "f, " + matrixValues[6] + "f, " + matrixValues[7] + "f, " + matrixValues[8] + "f});");
        this.notifyResult("mFinalPathMatrix.postScale(scaleX, scaleY);");
    }

    private float getMatrixScale(Matrix groupStackedMatrix) {
        float[] unitVectors = new float[]{0.0f, 1.0f, 1.0f, 0.0f};
        groupStackedMatrix.mapVectors(unitVectors);
        float scaleX = (float)Math.hypot(unitVectors[0], unitVectors[1]);
        float scaleY = (float)Math.hypot(unitVectors[2], unitVectors[3]);
        float crossProduct = this.cross(unitVectors[0], unitVectors[1], unitVectors[2], unitVectors[3]);
        float maxScale = Math.max(scaleX, scaleY);
        float matrixScale = 0.0f;
        if (maxScale > 0.0f) {
            matrixScale = Math.abs(crossProduct) / maxScale;
        }
        return matrixScale;
    }

    private float cross(float v1x, float v1y, float v2x, float v2y) {
        return v1x * v2y - v1y * v2x;
    }

    private void drawPathData(String pathData) {
        PathDataNode[] nodes = PathDataNode.createNodesFromPathData(pathData);
        float[] current = new float[6];
        char previousCommand = 'm';
        for (int i = 0; i < nodes.length; ++i) {
            this.addCommand(current, previousCommand, nodes[i].type, nodes[i].params);
            previousCommand = nodes[i].type;
        }
    }

    private void addCommand(float[] current, char previousCmd, char cmd, float[] val) {
        int incr = 2;
        float currentX = current[0];
        float currentY = current[1];
        float ctrlPointX = current[2];
        float ctrlPointY = current[3];
        float currentSegmentStartX = current[4];
        float currentSegmentStartY = current[5];
        switch (cmd) {
            case 'Z': 
            case 'z': {
                this.notifyResult("mPath.close();");
                currentX = currentSegmentStartX;
                currentY = currentSegmentStartY;
                ctrlPointX = currentSegmentStartX;
                ctrlPointY = currentSegmentStartY;
                this.notifyResult("mPath.moveTo(" + currentX + "f, " + ctrlPointY + "f);");
                break;
            }
            case 'L': 
            case 'M': 
            case 'T': 
            case 'l': 
            case 'm': 
            case 't': {
                incr = 2;
                break;
            }
            case 'H': 
            case 'V': 
            case 'h': 
            case 'v': {
                incr = 1;
                break;
            }
            case 'C': 
            case 'c': {
                incr = 6;
                break;
            }
            case 'Q': 
            case 'S': 
            case 'q': 
            case 's': {
                incr = 4;
                break;
            }
            case 'A': 
            case 'a': {
                incr = 7;
            }
        }
        for (int k = 0; k < val.length; k += incr) {
            switch (cmd) {
                case 'm': {
                    currentX += val[k];
                    currentY += val[k + 1];
                    if (k > 0) {
                        this.notifyResult("mPath.rLineTo(" + val[k] + "f, " + val[k + 1] + "f);");
                        break;
                    }
                    this.notifyResult("mPath.rMoveTo(" + val[k] + "f, " + val[k + 1] + "f);");
                    currentSegmentStartX = currentX;
                    currentSegmentStartY = currentY;
                    break;
                }
                case 'M': {
                    currentX = val[k];
                    currentY = val[k + 1];
                    if (k > 0) {
                        this.notifyResult("mPath.lineTo(" + val[k] + "f, " + val[k + 1] + "f);");
                        break;
                    }
                    this.notifyResult("mPath.moveTo(" + val[k] + "f, " + val[k + 1] + "f);");
                    currentSegmentStartX = currentX;
                    currentSegmentStartY = currentY;
                    break;
                }
                case 'l': {
                    this.notifyResult("mPath.rLineTo(" + val[k] + "f, " + val[k + 1] + "f);");
                    currentX += val[k];
                    currentY += val[k + 1];
                    break;
                }
                case 'L': {
                    this.notifyResult("mPath.lineTo(" + val[k] + "f, " + val[k + 1] + "f);");
                    currentX = val[k];
                    currentY = val[k + 1];
                    break;
                }
                case 'h': {
                    this.notifyResult("mPath.rLineTo(" + val[k] + "f, 0f);");
                    currentX += val[k];
                    break;
                }
                case 'H': {
                    this.notifyResult("mPath.lineTo(" + val[k] + "f, " + currentY + "f);");
                    currentX = val[k];
                    break;
                }
                case 'v': {
                    this.notifyResult("mPath.rLineTo(0f, " + val[k] + "f);");
                    currentY += val[k];
                    break;
                }
                case 'V': {
                    this.notifyResult("mPath.lineTo(" + currentX + "f, " + val[k] + "f);");
                    currentY = val[k];
                    break;
                }
                case 'c': {
                    this.notifyResult("mPath.rCubicTo(" + val[k] + "f, " + val[k + 1] + "f, " + val[k + 2] + "f, " + val[k + 3] + "f, " + val[k + 4] + "f, " + val[k + 5] + "f);");
                    ctrlPointX = currentX + val[k + 2];
                    ctrlPointY = currentY + val[k + 3];
                    currentX += val[k + 4];
                    currentY += val[k + 5];
                    break;
                }
                case 'C': {
                    this.notifyResult("mPath.cubicTo(" + val[k] + "f, " + val[k + 1] + "f, " + val[k + 2] + "f, " + val[k + 3] + "f, " + val[k + 4] + "f, " + val[k + 5] + "f);");
                    currentX = val[k + 4];
                    currentY = val[k + 5];
                    ctrlPointX = val[k + 2];
                    ctrlPointY = val[k + 3];
                    break;
                }
                case 's': {
                    float reflectiveCtrlPointX = 0.0f;
                    float reflectiveCtrlPointY = 0.0f;
                    if (previousCmd == 'c' || previousCmd == 's' || previousCmd == 'C' || previousCmd == 'S') {
                        reflectiveCtrlPointX = currentX - ctrlPointX;
                        reflectiveCtrlPointY = currentY - ctrlPointY;
                    }
                    this.notifyResult("mPath.rCubicTo(" + reflectiveCtrlPointX + "f, " + reflectiveCtrlPointY + "f, " + val[k] + "f, " + val[k + 1] + "f, " + val[k + 2] + "f, " + val[k + 3] + "f);");
                    ctrlPointX = currentX + val[k];
                    ctrlPointY = currentY + val[k + 1];
                    currentX += val[k + 2];
                    currentY += val[k + 3];
                    break;
                }
                case 'S': {
                    float reflectiveCtrlPointX = currentX;
                    float reflectiveCtrlPointY = currentY;
                    if (previousCmd == 'c' || previousCmd == 's' || previousCmd == 'C' || previousCmd == 'S') {
                        reflectiveCtrlPointX = 2.0f * currentX - ctrlPointX;
                        reflectiveCtrlPointY = 2.0f * currentY - ctrlPointY;
                    }
                    this.notifyResult("mPath.cubicTo(" + reflectiveCtrlPointX + "f, " + reflectiveCtrlPointY + "f, " + val[k] + "f, " + val[k + 1] + "f, " + val[k + 2] + "f, " + val[k + 3] + "f);");
                    ctrlPointX = val[k];
                    ctrlPointY = val[k + 1];
                    currentX = val[k + 2];
                    currentY = val[k + 3];
                    break;
                }
                case 'q': {
                    this.notifyResult("mPath.rQuadTo(" + val[k] + "f, " + val[k + 1] + "f, " + val[k + 2] + "f, " + val[k + 3] + "f);");
                    ctrlPointX = currentX + val[k];
                    ctrlPointY = currentY + val[k + 1];
                    currentX += val[k + 2];
                    currentY += val[k + 3];
                    break;
                }
                case 'Q': {
                    this.notifyResult("mPath.quadTo(" + val[k] + "f, " + val[k + 1] + "f, " + val[k + 2] + "f, " + val[k + 3] + "f);");
                    ctrlPointX = val[k];
                    ctrlPointY = val[k + 1];
                    currentX = val[k + 2];
                    currentY = val[k + 3];
                    break;
                }
                case 't': {
                    float reflectiveCtrlPointX = 0.0f;
                    float reflectiveCtrlPointY = 0.0f;
                    if (previousCmd == 'q' || previousCmd == 't' || previousCmd == 'Q' || previousCmd == 'T') {
                        reflectiveCtrlPointX = currentX - ctrlPointX;
                        reflectiveCtrlPointY = currentY - ctrlPointY;
                    }
                    this.notifyResult("mPath.rQuadTo(" + reflectiveCtrlPointX + "f, " + reflectiveCtrlPointY + "f, " + val[k] + "f, " + val[k + 1] + "f);");
                    ctrlPointX = currentX + reflectiveCtrlPointX;
                    ctrlPointY = currentY + reflectiveCtrlPointY;
                    currentX += val[k];
                    currentY += val[k + 1];
                    break;
                }
                case 'T': {
                    float reflectiveCtrlPointX = currentX;
                    float reflectiveCtrlPointY = currentY;
                    if (previousCmd == 'q' || previousCmd == 't' || previousCmd == 'Q' || previousCmd == 'T') {
                        reflectiveCtrlPointX = 2.0f * currentX - ctrlPointX;
                        reflectiveCtrlPointY = 2.0f * currentY - ctrlPointY;
                    }
                    this.notifyResult("mPath.quadTo(" + reflectiveCtrlPointX + "f, " + reflectiveCtrlPointY + "f, " + val[k] + "f, " + val[k + 1] + "f);");
                    ctrlPointX = reflectiveCtrlPointX;
                    ctrlPointY = reflectiveCtrlPointY;
                    currentX = val[k];
                    currentY = val[k + 1];
                    break;
                }
                case 'a': {
                    this.drawArc(currentX, currentY, val[k + 5] + currentX, val[k + 6] + currentY, val[k], val[k + 1], val[k + 2], val[k + 3] != 0.0f, val[k + 4] != 0.0f);
                    ctrlPointX = currentX += val[k + 5];
                    ctrlPointY = currentY += val[k + 6];
                    break;
                }
                case 'A': {
                    this.drawArc(currentX, currentY, val[k + 5], val[k + 6], val[k], val[k + 1], val[k + 2], val[k + 3] != 0.0f, val[k + 4] != 0.0f);
                    currentX = val[k + 5];
                    currentY = val[k + 6];
                    ctrlPointX = currentX;
                    ctrlPointY = currentY;
                }
            }
            previousCmd = cmd;
        }
        current[0] = currentX;
        current[1] = currentY;
        current[2] = ctrlPointX;
        current[3] = ctrlPointY;
        current[4] = currentSegmentStartX;
        current[5] = currentSegmentStartY;
    }

    private void drawArc(float x0, float y0, float x1, float y1, float a, float b, float theta, boolean isMoreThanHalf, boolean isPositiveArc) {
        double cy;
        double cx;
        double thetaD = Math.toRadians(theta);
        double cosTheta = Math.cos(thetaD);
        double sinTheta = Math.sin(thetaD);
        double x0p = ((double)x0 * cosTheta + (double)y0 * sinTheta) / (double)a;
        double y0p = ((double)(-x0) * sinTheta + (double)y0 * cosTheta) / (double)b;
        double x1p = ((double)x1 * cosTheta + (double)y1 * sinTheta) / (double)a;
        double y1p = ((double)(-x1) * sinTheta + (double)y1 * cosTheta) / (double)b;
        double dx = x0p - x1p;
        double dy = y0p - y1p;
        double xm = (x0p + x1p) / 2.0;
        double ym = (y0p + y1p) / 2.0;
        double dsq = dx * dx + dy * dy;
        if (dsq == 0.0) {
            return;
        }
        double disc = 1.0 / dsq - 0.25;
        if (disc < 0.0) {
            float adjust = (float)(Math.sqrt(dsq) / 1.99999);
            this.drawArc(x0, y0, x1, y1, a * adjust, b * adjust, theta, isMoreThanHalf, isPositiveArc);
            return;
        }
        double s = Math.sqrt(disc);
        double sdx = s * dx;
        double sdy = s * dy;
        if (isMoreThanHalf == isPositiveArc) {
            cx = xm - sdy;
            cy = ym + sdx;
        } else {
            cx = xm + sdy;
            cy = ym - sdx;
        }
        double eta0 = Math.atan2(y0p - cy, x0p - cx);
        double eta1 = Math.atan2(y1p - cy, x1p - cx);
        double sweep = eta1 - eta0;
        if (isPositiveArc != sweep >= 0.0) {
            sweep = sweep > 0.0 ? (sweep -= Math.PI * 2) : (sweep += Math.PI * 2);
        }
        double tcx = cx *= (double)a;
        cx = cx * cosTheta - (cy *= (double)b) * sinTheta;
        cy = tcx * sinTheta + cy * cosTheta;
        this.arcToBezier(cx, cy, a, b, x0, y0, thetaD, eta0, sweep);
    }

    private void arcToBezier(double cx, double cy, double a, double b, double e1x, double e1y, double theta, double start, double sweep) {
        int numSegments = (int)Math.ceil(Math.abs(sweep * 4.0 / Math.PI));
        double eta1 = start;
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double cosEta1 = Math.cos(eta1);
        double sinEta1 = Math.sin(eta1);
        double ep1x = -a * cosTheta * sinEta1 - b * sinTheta * cosEta1;
        double ep1y = -a * sinTheta * sinEta1 + b * cosTheta * cosEta1;
        double anglePerSegment = sweep / (double)numSegments;
        for (int i = 0; i < numSegments; ++i) {
            double eta2 = eta1 + anglePerSegment;
            double sinEta2 = Math.sin(eta2);
            double cosEta2 = Math.cos(eta2);
            double e2x = cx + a * cosTheta * cosEta2 - b * sinTheta * sinEta2;
            double e2y = cy + a * sinTheta * cosEta2 + b * cosTheta * sinEta2;
            double ep2x = -a * cosTheta * sinEta2 - b * sinTheta * cosEta2;
            double ep2y = -a * sinTheta * sinEta2 + b * cosTheta * cosEta2;
            double tanDiff2 = Math.tan((eta2 - eta1) / 2.0);
            double alpha = Math.sin(eta2 - eta1) * (Math.sqrt(4.0 + 3.0 * tanDiff2 * tanDiff2) - 1.0) / 3.0;
            double q1x = e1x + alpha * ep1x;
            double q1y = e1y + alpha * ep1y;
            double q2x = e2x - alpha * ep2x;
            double q2y = e2y - alpha * ep2y;
            this.notifyResult("mPath.cubicTo(" + (float)q1x + "f, " + (float)q1y + "f, " + (float)q2x + "f, " + (float)q2y + "f, " + (float)e2x + "f, " + (float)e2y + "f);");
            eta1 = eta2;
            e1x = e2x;
            e1y = e2y;
            ep1x = ep2x;
            ep1y = ep2y;
        }
    }

    private void drawClipPath() {
        this.notifyResult("mRenderPath.addPath(mPath, mFinalPathMatrix);");
        this.notifyResult("canvas.clipPath(mRenderPath, Region.Op.REPLACE);");
    }

    private void drawPath(Path path, float matrixScale) {
        if (path.trimPathStart != 0.0f || path.trimPathEnd != 1.0f) {
            float start = (path.trimPathStart + path.trimPathOffset) % 1.0f;
            float end = (path.trimPathEnd + path.trimPathOffset) % 1.0f;
            this.notifyResult("if (mPathMeasure == null) {");
            this.notifyResult("    mPathMeasure = new PathMeasure();");
            this.notifyResult("}");
            this.notifyResult("mPathMeasure.setPath(mPath, false);");
            this.notifyResult("float len" + this.mCount + " = mPathMeasure.getLength();");
            this.notifyResult("float start" + this.mCount + " = " + start + " * len" + this.mCount);
            this.notifyResult("float end" + this.mCount + " = " + end + " * len" + this.mCount);
            this.notifyResult("mPath.reset();");
            this.notifyResult("if (start" + this.mCount + " > end" + this.mCount + ") {");
            this.notifyResult("    mPathMeasure.getSegment(start" + this.mCount + ", len" + this.mCount + ", path, true);");
            this.notifyResult("    mPathMeasure.getSegment(0f, end" + this.mCount + ", path, true);");
            this.notifyResult("} else {");
            this.notifyResult("    mPathMeasure.getSegment(start" + this.mCount + ", end" + this.mCount + ", path, true);");
            this.notifyResult("}");
            this.notifyResult("mPath.rLineTo(0, 0);");
        }
        this.notifyResult("mRenderPath.addPath(mPath, mFinalPathMatrix);");
        String fillType = null;
        if ("evenOdd".equals(path.fillType)) {
            fillType = "android.graphics.Path.FillType.EVEN_ODD";
        } else if ("nonZero".equals(path.fillType)) {
            fillType = "android.graphics.Path.FillType.WINDING";
        }
        if (fillType != null) {
            this.notifyResult("mRenderPath.setFillType(" + fillType + ");");
        }
        if (path.fillColor != 0) {
            if (!this.isFillPaintInited) {
                this.isFillPaintInited = true;
                this.notifyResult("if (mFillPaint == null) {");
                this.notifyResult("    mFillPaint = new Paint();");
                this.notifyResult("    mFillPaint.setStyle(Paint.Style.FILL);");
                this.notifyResult("    mFillPaint.setAntiAlias(true);");
                this.notifyResult("}");
            }
            this.notifyResult("mFillPaint.setColor(applyAlpha(" + path.fillColor + ", " + path.fillAlpha + "f));");
            this.notifyResult("mFillPaint.setColorFilter(filter);");
            this.notifyResult("canvas.drawPath(mRenderPath, mFillPaint);");
        }
        if (path.strokeColor != 0) {
            if (!this.isStrokePaintInited) {
                this.isStrokePaintInited = true;
                this.notifyResult("if (mStrokePaint == null) {");
                this.notifyResult("    mStrokePaint = new Paint();");
                this.notifyResult("    mStrokePaint.setStyle(Paint.Style.STROKE);");
                this.notifyResult("    mStrokePaint.setAntiAlias(true);");
                this.notifyResult("}");
            }
            if (path.strokeLineJoin != null) {
                String strokeLineJoin = null;
                if ("bevel".equals(path.strokeLineJoin)) {
                    strokeLineJoin = "Paint.Join.BEVEL";
                } else if ("miter".equals(path.strokeLineJoin)) {
                    strokeLineJoin = "Paint.Join.MITER";
                } else if ("round".equals(path.strokeLineJoin)) {
                    strokeLineJoin = "Paint.Join.ROUND";
                }
                this.notifyResult("mStrokePaint.setStrokeJoin(" + strokeLineJoin + ");");
            }
            if (path.strokeLineCap != null) {
                String strokeLineCap = null;
                if ("butt".equals(path.strokeLineCap)) {
                    strokeLineCap = "Paint.Cap.BUTT";
                } else if ("round".equals(path.strokeLineCap)) {
                    strokeLineCap = "Paint.Cap.ROUND";
                } else if ("square".equals(path.strokeLineCap)) {
                    strokeLineCap = "Paint.Cap.SQUARE";
                }
                this.notifyResult("mStrokePaint.setStrokeCap(" + strokeLineCap + ");");
            }
            this.notifyResult("mStrokePaint.setStrokeMiter(" + path.strokeMiterLimit + "f);");
            this.notifyResult("mStrokePaint.setColor(applyAlpha(" + path.strokeColor + ", " + path.strokeAlpha + "f));");
            this.notifyResult("mStrokePaint.setColorFilter(filter);");
            this.notifyResult("mStrokePaint.setStrokeWidth(minScale * " + matrixScale + "f * " + path.strokeWidth + "f);");
            this.notifyResult("canvas.drawPath(mRenderPath, mStrokePaint);");
        }
    }
}

