package com.maniu.wechatimagesend;

import android.Manifest;
import android.app.Activity;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Build;
import android.os.Environment;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class MainActivity extends Activity {


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        checkPermission(this);
    }
    public static boolean checkPermission(
            Activity activity) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && activity.checkSelfPermission(
                Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
            activity.requestPermissions(new String[]{
                    Manifest.permission.READ_EXTERNAL_STORAGE,
                    Manifest.permission.WRITE_EXTERNAL_STORAGE
            }, 1);

        }
        return false;
    }


    public void onLoad(View view) {
        File input = new File(Environment.getExternalStorageDirectory(), "main.jpg");
        Bitmap inputBitmap = BitmapFactory.decodeFile(input.getAbsolutePath());
        File output= new File(Environment.getExternalStorageDirectory(), "微信压缩.jpg");
        /**
         *
         */
        compress(inputBitmap, output.getAbsolutePath());
        //        质量压缩
        File output1= new File(Environment.getExternalStorageDirectory(), "质量压缩.jpg");
        compressQuality(inputBitmap, output1);
//        尺寸压缩
        File output2= new File(Environment.getExternalStorageDirectory(), "尺寸压缩.jpg");
        compressSize(inputBitmap,output2);
    }


    public native void compress(Bitmap bitmap, String path);
    /**
     * 1. 质量压缩
     设置bitmap options属性，降低图片的质量，像素不会减少
     第一个参数为需要压缩的bitmap图片对象，第二个参数为压缩后图片保存的位置
     设置options 属性0-100，来实现压缩
     * @param bmp
     * @param file
     */
    public   void compressQuality(Bitmap bmp,File file) {
        // 0-100 100为不压缩
        int options = 10;
        Canvas canvas;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        // 把压缩后的数据存放到baos中
        bmp.compress(Bitmap.CompressFormat.JPEG,  10, baos);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(baos.toByteArray());
            fos.flush();
            fos.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     *
     * 2. 尺寸压缩
     通过缩放图片像素来减少图片占用内存大小
     * @param bmp
     * @param file
     */

    public   void compressSize(Bitmap bmp, File file){
        // 尺寸压缩倍数,值越大，图片尺寸越小
        int ratio =6;
        // 压缩Bitmap到对应尺寸
        Bitmap result = Bitmap.createBitmap(bmp.getWidth() / ratio, bmp.getHeight() / ratio, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(result);
        Rect rect = new Rect(0, 0, bmp.getWidth() / ratio, bmp.getHeight() / ratio);
        canvas.drawBitmap(bmp, null, rect, null);

        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        // 把压缩后的数据存放到baos中
        result.compress(Bitmap.CompressFormat.JPEG, 100 ,baos);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(baos.toByteArray());
            fos.flush();
            fos.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
static {
        System.loadLibrary("jpegbither");
        System.loadLibrary("native-lib");
    }

}
