/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.DetailResultProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.CategoryDescriptor;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IClassLoader;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.AbstractPaneJob;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.browser.Policy;
import org.eclipse.mat.ui.internal.browser.QueryBrowserPopup;
import org.eclipse.mat.ui.util.Copy;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.IPolicy;
import org.eclipse.mat.ui.util.PaneState;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryContextMenu {
    private MultiPaneEditor editor;
    private List<ContextProvider> contextProvider;
    private List<DetailResultProvider> resultProvider;
    private QueryResult queryResult;
    private static final Pattern PATH_PATTERN = Pattern.compile("^[^ ]*\\.([A-Z][\\p{Alnum}$]([^ .])*.*)$");

    public QueryContextMenu(AbstractEditorPane pane, QueryResult result) {
        this(pane.getEditor(), result);
    }

    public QueryContextMenu(MultiPaneEditor editor, QueryResult result) {
        this.editor = editor;
        this.queryResult = result;
        if (!(result.getSubject() instanceof IStructuredResult)) {
            throw new UnsupportedOperationException(Messages.QueryContextMenu_SubjectMustBeOfType);
        }
        this.resultProvider = result.getResultMetaData().getDetailResultProviders();
        this.contextProvider = result.getResultMetaData().getContextProviders();
        if (this.contextProvider.isEmpty()) {
            this.contextProvider = new ArrayList<ContextProvider>(1);
            this.contextProvider.add(result.getDefaultContextProvider());
        }
    }

    public QueryContextMenu(MultiPaneEditor editor, ContextProvider provider) {
        this.editor = editor;
        this.resultProvider = new ArrayList<DetailResultProvider>(0);
        this.contextProvider = new ArrayList<ContextProvider>(1);
        this.contextProvider.add(provider);
    }

    public QueryContextMenu(AbstractEditorPane pane, ContextProvider provider) {
        this(pane.getEditor(), provider);
    }

    public final void addContextActions(PopupMenu manager, IStructuredSelection selection, Control control) {
        if (selection.isEmpty()) {
            return;
        }
        this.resultMenu(manager, selection);
        String label = null;
        boolean shownSystem = false;
        for (ContextProvider p : this.contextProvider) {
            ArrayList<IContextObject> menuContext = new ArrayList<IContextObject>();
            for (Object selected : selection) {
                IContextObject ctx = p.getContext(selected);
                if (ctx == null) continue;
                menuContext.add(ctx);
            }
            PopupMenu menu = manager;
            String menuLabel = p.getLabel();
            if (menuLabel != null) {
                menu = new PopupMenu(menuLabel);
                URL url = p.getIcon();
                if (url != null) {
                    menu.setImageDescriptor(MemoryAnalyserPlugin.getDefault().getImageDescriptor(url));
                }
                manager.add(menu);
            }
            if (label == null) {
                label = this.getLabel(selection);
            }
            if (!menuContext.isEmpty()) {
                this.queryMenu(menu, menuContext, label);
            }
            if (!menuContext.isEmpty()) {
                this.systemMenu(menu, control);
                shownSystem = true;
            }
            if (menuContext.isEmpty()) continue;
            this.customMenu(menu, menuContext, p, label);
        }
        if (!shownSystem) {
            this.systemMenu(manager, control);
        }
    }

    private String getLabel(IStructuredSelection selection) {
        String label;
        if (this.queryResult == null) {
            label = Messages.QueryContextMenu_context;
        } else if (selection.size() == 1) {
            IStructuredResult result = (IStructuredResult)this.queryResult.getSubject();
            Object value = result.getColumnValue(selection.getFirstElement(), 0);
            if (value == null) {
                label = MessageUtil.format((String)Messages.QueryContextMenu_selectionOf, (Object[])new Object[]{this.queryResult.getQuery() != null ? this.queryResult.getQuery().getName() : this.queryResult.getCommand()});
            } else {
                String sval;
                Column col = result.getColumns()[0];
                if (col.getFormatter() != null) {
                    try {
                        sval = col.getFormatter().format(value);
                    }
                    catch (IllegalArgumentException e) {
                        sval = QueryContextMenu.fixLabel(String.valueOf(value));
                    }
                } else {
                    sval = QueryContextMenu.fixLabel(String.valueOf(value));
                }
                label = MessageUtil.format((String)Messages.QueryContextMenu_selectionOf, (Object[])new Object[]{"'" + sval + "'"});
            }
        } else {
            label = this.queryResult.getQuery() != null ? MessageUtil.format((String)Messages.QueryContextMenu_selectionOf, (Object[])new Object[]{this.queryResult.getQuery().getName()}) : MessageUtil.format((String)Messages.QueryContextMenu_selectionOf, (Object[])new Object[]{this.queryResult.getCommand()});
        }
        return label;
    }

    private void resultMenu(PopupMenu menu, IStructuredSelection selection) {
        if (selection.size() == 1) {
            boolean hasContextResultProviderMenu = false;
            for (final DetailResultProvider r : this.resultProvider) {
                Object firstElement;
                boolean hasResult = r.hasResult(firstElement = selection.getFirstElement());
                if (!hasResult) continue;
                final PaneState originator = this.editor.getActiveEditor().getPaneState();
                menu.add(new Action(r.getLabel(), r.getIcon() != null ? MemoryAnalyserPlugin.getDefault().getImageDescriptor(r.getIcon()) : null){

                    public void run() {
                        new AbstractPaneJob(MessageUtil.format((String)Messages.QueryContextMenu_Processing, (Object[])new Object[]{r.getLabel()}), null){

                            protected IStatus doRun(IProgressMonitor monitor) {
                                try {
                                    IResult result = r.getResult(firstElement, (IProgressListener)new ProgressMonitorWrapper(monitor));
                                    QueryResult qr = new QueryResult(null, MessageUtil.format((String)Messages.QueryContextMenu_Details, (Object[])new Object[]{r.getLabel()}), result);
                                    QueryExecution.displayResult(QueryContextMenu.this.editor, originator, null, qr, false);
                                    return Status.OK_STATUS;
                                }
                                catch (SnapshotException e) {
                                    return ErrorHelper.createErrorStatus(e);
                                }
                            }
                        }.schedule();
                    }
                });
                hasContextResultProviderMenu = true;
            }
            if (hasContextResultProviderMenu) {
                menu.addSeparator();
            }
        }
    }

    private void queryMenu(PopupMenu menu, List<IContextObject> menuContext, String label) {
        final Policy policy = new Policy(menuContext, label);
        long deadline = System.currentTimeMillis() + 1000L;
        this.addCategories(menu, QueryRegistry.instance().getRootCategory(), menuContext, label, policy, deadline);
        Action queryBrowser = new Action(Messages.QueryDropDownMenuAction_SearchQueries){

            public void run() {
                new QueryBrowserPopup(QueryContextMenu.this.editor, false, policy).open();
            }
        };
        queryBrowser.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/query_browser.gif"));
        queryBrowser.setToolTipText(Messages.QueryDropDownMenuAction_SeachQueriesByName);
        queryBrowser.setActionDefinitionId("org.eclipse.mat.ui.query.browser.QueryBrowser2");
        menu.add(queryBrowser);
    }

    private void addCategories(PopupMenu menu, CategoryDescriptor root, List<IContextObject> menuContext, String label, IPolicy policy, long deadline) {
        for (Object item : root.getChildren()) {
            QueryDescriptor query;
            if (item instanceof CategoryDescriptor) {
                CategoryDescriptor sub = (CategoryDescriptor)item;
                PopupMenu subManager = new PopupMenu(sub.getName());
                menu.add(subManager);
                this.addCategories(subManager, sub, menuContext, label, policy, deadline);
                continue;
            }
            if (!(item instanceof QueryDescriptor) || !policy.accept(query = (QueryDescriptor)item) || System.currentTimeMillis() <= deadline && this.unsuitableSubjects(query, menuContext)) continue;
            menu.add(new QueryAction(this.editor, query, policy));
        }
    }

    private static String[] extractSubjects(QueryDescriptor query) {
        Subject s;
        Subjects subjects = query.getCommandType().getAnnotation(Subjects.class);
        Object cls = subjects != null ? subjects.value() : ((s = query.getCommandType().getAnnotation(Subject.class)) != null ? new String[]{s.value()} : null);
        return cls;
    }

    public boolean instanceOf(ISnapshot snapshot, int o, String className) throws SnapshotException {
        IClass cls = snapshot.getClassOf(o);
        return this.instanceOf(snapshot, cls, className);
    }

    /*
     * Unable to fully structure code
     */
    public boolean instanceOf(ISnapshot snapshot, IClass cls, String className) throws SnapshotException {
        if (!cls.doesExtend(className)) ** GOTO lbl19
        return true;
lbl-1000:
        // 1 sources

        {
            n2 = cls.getName();
            n3 = n2.substring(0, n2.length() - 2);
            className = className.substring(0, className.length() - 2);
            found = false;
            classes = snapshot.getClassesByName(n3, false);
            if (classes == null) {
                return false;
            }
            for (IClass c2 : classes) {
                if (c2.getClassLoaderId() != cls.getClassLoaderId()) continue;
                cls = c2;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            if (!cls.doesExtend(className)) continue;
            return true;
lbl19:
            // 2 sources

            ** while (className.endsWith((String)"[]") && cls.isArrayType())
        }
lbl20:
        // 1 sources

        return false;
    }

    public boolean anyInstances(ISnapshot snapshot, String cn) throws SnapshotException {
        Collection ss = snapshot.getClassesByName(cn, false);
        if (ss == null || ss.isEmpty()) {
            return false;
        }
        for (IClass cls : ss) {
            if (cls.getNumberOfObjects() <= 0) continue;
            return true;
        }
        for (IClass cls : ss) {
            if (!this.anySubInstances(cls)) continue;
            return true;
        }
        return false;
    }

    public boolean anySubInstances(IClass cls) {
        for (IClass cls2 : cls.getSubclasses()) {
            if (cls2.getNumberOfObjects() <= 0) continue;
            return true;
        }
        for (IClass cls2 : cls.getSubclasses()) {
            if (!this.anySubInstances(cls2)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean unsuitableSubjects(QueryDescriptor query, List<IContextObject> menuContext) {
        boolean skip;
        String[] cls = QueryContextMenu.extractSubjects(query);
        if (cls != null) {
            ISnapshot snapshot = (ISnapshot)this.editor.getQueryContext().get(ISnapshot.class, null);
            int count = 0;
            String[] stringArray = cls;
            int n = cls.length;
            int n2 = 0;
            while (n2 < n) {
                String cn = stringArray[n2];
                try {
                    Collection ss = snapshot.getClassesByName(cn, false);
                    if (ss != null && !ss.isEmpty()) {
                        count += ss.size();
                        break;
                    }
                }
                catch (SnapshotException ss) {
                    // empty catch block
                }
                ++n2;
            }
            if (count == 0) {
                return true;
            }
            int limit = 1000;
            int inspected = 0;
            boolean skipCheckObjectIds = false;
            ArrayList<IContextObject> menuContext2 = new ArrayList<IContextObject>(menuContext);
            Collections.shuffle(menuContext2);
            for (IContextObject ico : menuContext) {
                if (inspected >= limit) {
                    return false;
                }
                if (ico instanceof IContextObjectSet) {
                    int[] os;
                    IContextObjectSet icos = (IContextObjectSet)ico;
                    Class<?> enclosingClass = icos.getClass().getEnclosingClass();
                    if (Histogram.class.equals(enclosingClass) || Histogram.SuperclassTree.class.equals(enclosingClass) || Histogram.ClassLoaderTree.class.equals(enclosingClass) || Histogram.PackageTree.class.equals(enclosingClass) && icos.getObjectId() != -1) {
                        IObject io;
                        int type = icos.getObjectId();
                        try {
                            io = snapshot.getObject(type);
                        }
                        catch (SnapshotException e) {
                            continue;
                        }
                        if (io instanceof IClass) {
                            IClass ic = (IClass)io;
                            String[] stringArray2 = cls;
                            int n3 = cls.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String cn = stringArray2[n4];
                                try {
                                    if (this.instanceOf(snapshot, ic, cn)) {
                                        if (Histogram.class.equals(enclosingClass) && icos.getOQL() != null && ic.getNumberOfObjects() > 0) {
                                            return false;
                                        }
                                        if (Histogram.SuperclassTree.class.equals(enclosingClass) && icos.getOQL() != null && (ic.getNumberOfObjects() > 0 || this.anySubInstances(ic))) {
                                            return false;
                                        }
                                        if (Histogram.ClassLoaderTree.class.equals(enclosingClass) && icos.getOQL() != null && ic.getNumberOfObjects() > 0) {
                                            return false;
                                        }
                                        if (Histogram.PackageTree.class.equals(enclosingClass) && icos.getOQL() != null && ic.getNumberOfObjects() > 0) {
                                            return false;
                                        }
                                        if (skipCheckObjectIds) {
                                            return false;
                                        }
                                        int[] os2 = icos.getObjectIds();
                                        if (os2.length > 0) {
                                            return false;
                                        }
                                    } else if (Histogram.SuperclassTree.class.equals(enclosingClass)) {
                                        for (IClass ic2 : ic.getAllSubclasses()) {
                                            if (!this.instanceOf(snapshot, ic2, cn)) continue;
                                            if (icos.getOQL() != null && (ic2.getNumberOfObjects() > 0 || this.anySubInstances(ic2))) {
                                                return false;
                                            }
                                            if (skipCheckObjectIds) {
                                                return false;
                                            }
                                            int[] os3 = icos.getObjectIds();
                                            if (os3.length <= 0) continue;
                                            return false;
                                        }
                                    }
                                }
                                catch (SnapshotException e) {
                                    e.printStackTrace();
                                }
                                ++n4;
                            }
                            ++inspected;
                            continue;
                        }
                        if (!(io instanceof IClassLoader)) continue;
                        IClassLoader icl = (IClassLoader)io;
                        String[] stringArray3 = cls;
                        int n5 = cls.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String cn = stringArray3[n6];
                            try {
                                for (IClass ic2 : icl.getDefinedClasses()) {
                                    if (!this.instanceOf(snapshot, ic2, cn)) continue;
                                    if (icos.getOQL() != null && ic2.getNumberOfObjects() > 0) {
                                        return false;
                                    }
                                    return false;
                                }
                            }
                            catch (SnapshotException snapshotException) {
                                // empty catch block
                            }
                            ++n6;
                        }
                        ++inspected;
                        continue;
                    }
                    if (Histogram.PackageTree.class.equals(enclosingClass) && icos.getObjectId() == -1) {
                        String oql = icos.getOQL();
                        String oqlref = OQL.instancesByPattern((Pattern)Pattern.compile(""), (boolean)false);
                        String oqlPrefix = oqlref.substring(0, oqlref.length() - 1);
                        String oqlSuffix = oqlref.substring(oqlref.length() - 1);
                        if (oql != null && oql.startsWith(oqlPrefix) && oql.endsWith(oqlSuffix) && oql.substring(oqlPrefix.length(), oql.length() - oqlSuffix.length()).indexOf(34) < 0) {
                            String pat = oql.substring(oqlPrefix.length(), oql.length() - oqlSuffix.length());
                            try {
                                Collection classes = snapshot.getClassesByName(Pattern.compile(pat), false);
                                String[] stringArray4 = cls;
                                int n7 = cls.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    String cn = stringArray4[n8];
                                    for (IClass ic2 : classes) {
                                        try {
                                            if (!this.instanceOf(snapshot, ic2, cn)) continue;
                                            if (icos.getOQL() != null && ic2.getNumberOfObjects() > 0) {
                                                return false;
                                            }
                                            return false;
                                        }
                                        catch (SnapshotException snapshotException) {
                                            // empty catch block
                                        }
                                    }
                                    ++n8;
                                }
                            }
                            catch (PatternSyntaxException classes) {
                            }
                            catch (SnapshotException classes) {
                                // empty catch block
                            }
                            ++inspected;
                            continue;
                        }
                        return false;
                    }
                    try {
                        os = icos.getObjectIds();
                    }
                    catch (RuntimeException e) {
                        return false;
                    }
                    if ((inspected += os.length) >= limit) {
                        return false;
                    }
                    String[] stringArray5 = cls;
                    int n9 = cls.length;
                    int n10 = 0;
                    while (n10 < n9) {
                        String cn = stringArray5[n10];
                        int[] nArray = os;
                        int n11 = os.length;
                        int n12 = 0;
                        while (n12 < n11) {
                            int o = nArray[n12];
                            try {
                                if (this.instanceOf(snapshot, o, cn)) {
                                    return false;
                                }
                            }
                            catch (SnapshotException snapshotException) {
                                // empty catch block
                            }
                            ++n12;
                        }
                        ++n10;
                    }
                    continue;
                }
                int o = ico.getObjectId();
                String[] stringArray6 = cls;
                int n13 = cls.length;
                int n14 = 0;
                while (n14 < n13) {
                    String cn = stringArray6[n14];
                    try {
                        if (this.instanceOf(snapshot, o, cn)) {
                            return false;
                        }
                    }
                    catch (SnapshotException snapshotException) {
                        // empty catch block
                    }
                    ++n14;
                }
                ++inspected;
            }
            skip = true;
        } else {
            skip = false;
        }
        return skip;
    }

    private void systemMenu(PopupMenu menu, final Control control) {
        if (control == null) {
            return;
        }
        QueryDescriptor qd = QueryRegistry.instance().getQuery("address");
        if (qd != null) {
            String menuName = QueryRegistry.instance().getRootCategory().resolve(qd.getCategory()).getName();
            PopupMenu menu2 = menu.getChildMenu(menuName);
            if (menu2 != null) {
                menu = menu2;
            } else {
                menu2 = new PopupMenu(menuName);
                menu.add(menu2);
                menu = menu2;
            }
        }
        Action copySelectionAction = new Action(){

            public String getText() {
                return Messages.QueryContextMenu_Selection;
            }

            public void run() {
                Copy.copyToClipboard(control);
            }
        };
        copySelectionAction.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/copy.gif"));
        copySelectionAction.setToolTipText(Messages.QueryContextMenu_CopySelectionToTheClipboard);
        menu.add(copySelectionAction);
    }

    protected void customMenu(PopupMenu menu, List<IContextObject> menuContext, ContextProvider provider, String label) {
    }

    private static String fixLabel(String label) {
        Matcher matcher = PATH_PATTERN.matcher(label);
        label = matcher.matches() ? matcher.group(1) : label;
        return label.length() > 100 ? String.valueOf(label.substring(0, 100)) + "..." : label;
    }

    public static final class QueryAction
    extends Action {
        MultiPaneEditor editor;
        QueryDescriptor query;
        IPolicy policy;

        public QueryAction(MultiPaneEditor editor, QueryDescriptor query, IPolicy policy) {
            super(query.getName());
            this.editor = editor;
            this.query = query;
            this.policy = policy;
            this.setToolTipText(query.getShortDescription());
            this.setImageDescriptor(MemoryAnalyserPlugin.getDefault().getImageDescriptor(query));
        }

        public void run() {
            try {
                ISnapshot snapshot = (ISnapshot)this.editor.getQueryContext().get(ISnapshot.class, null);
                ArgumentSet set = this.query.createNewArgumentSet(this.editor.getQueryContext());
                this.policy.fillInObjectArguments(snapshot, this.query, set);
                QueryExecution.execute(this.editor, this.editor.getActiveEditor().getPaneState(), null, set, !this.query.isShallow(), false);
            }
            catch (SnapshotException e) {
                ErrorHelper.logThrowableAndShowMessage(e);
            }
        }
    }
}

