package com.mnvipmemoryopt;

import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

public class ChurnActivity extends AppCompatActivity {

    private Handler handler;

    private static final B a = new B();

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_churn);
        init();
        setViewsListener();
    }

    private void init() {
        handler = new Handler(Looper.getMainLooper());
    }

    private void setViewsListener(){
        findViewById(R.id.button).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                churn(0);
            }
        });
    }

    Runnable r = new Runnable() {
        @Override
        public void run() {
            allocate();
        }
    };

    private void churn(int delay){
        handler.postDelayed(r,delay);
    }

    private void allocate(){
        for(int i=0; i<100;i++){
            String ob[] = new String[1000];
//            那么一个空 String 所占空间为：
//            对象头（8 字节）。
//            String占用内存计算公式：8 + 2*n，n为字符串长度。
//            在 Java 里数组也是对象，因而数组也有对象头，
//            故一个数组所占的空间为对象头所占的空间加上数组长度加上数组的引用，
//            即 8 + 4 + 4= 16 字节 。
        }
        churn(50);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        handler.removeCallbacks(r);
    }

}
