package com.maniu.pmsmniu;

import androidx.appcompat.app.AppCompatActivity;

import android.Manifest;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.widget.Toast;

import java.io.File;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        checkPermission(this);


        startActivity(new Intent());
        IntentFilter filter =new IntentFilter();
        filter.addAction("com.maniu.receiver2");
        registerReceiver(new PersonPickerRecevier(), filter);
    }
    class PersonPickerRecevier extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            Toast.makeText(context, "3： 宿主三次握手完成", Toast.LENGTH_SHORT).show();
        }
    }
    public static boolean checkPermission(
            Activity activity) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && activity.checkSelfPermission(
                Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
            activity.requestPermissions(new String[]{
                    Manifest.permission.READ_EXTERNAL_STORAGE,
                    Manifest.permission.WRITE_EXTERNAL_STORAGE
            }, 1);

        }
        return false;
    }
    public void registBroaderCast(View view) {

        MyPackageParser myPackageParser = new MyPackageParser();
        try {
            myPackageParser.parserReceivers(this, new File(Environment.getExternalStorageDirectory(), "input.apk"));
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    public void sendBroaderCast(View view) {
//Object
        Toast.makeText(this, "1： 宿主:  准备发送广播", Toast.LENGTH_SHORT).show();
        Intent intent =new Intent();
        intent.setAction("com.maniu.receiver1");
        sendBroadcast(intent);

    }
}