package com.mnviphandler;

import android.util.Log;

import androidx.annotation.Nullable;

public class ThreadLocalTest {

    public void test(){
        final ThreadLocal<String> threadLocal = new ThreadLocal<String>(){
            @Nullable
            @Override
            protected String initialValue() {
                // 重写初始化方法，默认返回null，如果ThreadLocalMap拿不到值再调用初始化方法
                return "码牛学院";
            }
        };
        // 从ThreadLocalMap中获取String的值，key是主线程
        Log.e("xxxxxx","主线程threadLocal："+threadLocal.get());

        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                String value1 = threadLocal.get();
                Log.e("xxxxxx","Thread-0："+value1);

                threadLocal.set("River");
                String value2 = threadLocal.get();
                Log.e("xxxxxx","after set method : Thread-0："+value2);

            }
        });
        thread.start();



    }

    private void test1(){

    }



}
