package com.mnviphandler;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        handler.sendEmptyMessageDelayed(HANDLER_FLAG,1000);
    }
    //先后间隔 1秒内  从handler的 MQ 中取出 msg  修改 相同的参数arg1 是否修改的同一个 msg

    private static int HANDLER_FLAG = 666;

    private static Handler handler = new Handler(){
        @Override
        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            handler.sendEmptyMessageDelayed(HANDLER_FLAG,1000);
            //MainActivity   打断这条线->   Handler->msg(target)    打断这条线   ->MessageQueue->Looper->main()->ActivityThread->app启动之时
        }
    };

    @Override
    protected void onDestroy() {
        handler.removeCallbacksAndMessages(null);
        handler.removeMessages(HANDLER_FLAG);
        super.onDestroy();
    }

}
