package com.maniu.sandboxframework.fileaccess;

import android.content.Context;

import com.maniu.sandboxframework.meadia.MediaStoreAccessImp;
import com.maniu.sandboxframework.responce.FileResponse;
import com.maniu.sandboxframework.resquest.NewFileRequest;

public class FileAccessManager {
    private static FileAccessManager sInstance;
    private static final String MODE_READ = "r";

    private FileAccessManager() {

    }

    public static FileAccessManager getInstance() {
        if (sInstance == null) {
            synchronized (FileAccessManager.class) {
                if (sInstance == null) {
                    sInstance = new FileAccessManager();
                }
            }
        }
        return sInstance;
    }
    public FileResponse newCreateFile(Context context, NewFileRequest request) {
//            不是沙箱    普通的文件  是沙箱模式  优化  ----》
        FileAccessInterface fileAccessInterface = FileAccessFactory.getCreateFileAccess(request.getFile().getAbsolutePath());
        return fileAccessInterface.newCreateFile(context, request);
    }

}
