package com.maniu.sandboxframework.meadia;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;

import com.maniu.sandboxframework.fileaccess.FileAccessInterface;
import com.maniu.sandboxframework.responce.FileResponse;
import com.maniu.sandboxframework.resquest.CopyFileRequest;
import com.maniu.sandboxframework.resquest.DeleteFileRequest;
import com.maniu.sandboxframework.resquest.NewFileRequest;
import com.maniu.sandboxframework.resquest.OpenFileRequest;
import com.maniu.sandboxframework.resquest.RenameToFileRequest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;

//沙箱  普通文件
public class MediaStoreAccessImp implements FileAccessInterface {
    private static MediaStoreAccessImp sInstance;

    private MediaStoreAccessImp() {

    }

    public static MediaStoreAccessImp getInstance() {
        if (sInstance == null) {
            synchronized (MediaStoreAccessImp.class) {
                if (sInstance == null) {
                    sInstance = new MediaStoreAccessImp();
                }
            }
        }
        return sInstance;
    }

    @Override
    public ParcelFileDescriptor openFile(Context context, OpenFileRequest request) throws FileNotFoundException {
        return null;
    }

    @Override
    public FileResponse newCreateFile(Context context, NewFileRequest request) {
        if (request != null) {
            Uri uri = getInsertContentUri(request);
            FileResponse response =newCreateFile(context, uri, request);
            return response;
        }
        return null;
    }
//29  30 沙箱做   28
    private static FileResponse newCreateFile(Context context,
                                              Uri uri,
                                              NewFileRequest request) {
        ContentResolver contentResolver = context.getContentResolver();
        ContentValues contentValues = new ContentValues();
        String path = Environment.DIRECTORY_DOWNLOADS + "/"+request.getFile().getName();
//        relative_path      Download/Maniu  数据库     字段   不明朗 反射
        contentValues.put(MediaStore.Downloads.RELATIVE_PATH,path);
        contentValues.put(MediaStore.Downloads.DISPLAY_NAME, path);
        contentValues.put(MediaStore.Downloads.TITLE,path);
        Uri resultUri =contentResolver.insert(uri, contentValues);
        boolean result = false;
        if (resultUri == null) {
            result = false;
        }else {
            result = true;
        }
        FileResponse response=new FileResponse();
        response.setmUri(resultUri);
        response.setmIsSuccess(result);
        return response;
    }
    private Uri getInsertContentUri(NewFileRequest request) {
        Uri uri = request.getContentUri();
        if (uri == null) {
            return MediaStore.Files.getContentUri("external");

        }
        return uri;
    }

    @Override
    public boolean delete(Context context, DeleteFileRequest request) {
        return false;
    }

    @Override
    public FileResponse renameTo(Context context, RenameToFileRequest renameRequest) {
        return null;
    }

    @Override
    public boolean mkdirs(Context context, File file) {
        return false;
    }

    @Override
    public InputStream getInputStream(Context context, OpenFileRequest request) throws FileNotFoundException {
        return null;
    }

    @Override
    public OutputStream getOutStream(Context context, OpenFileRequest request) throws FileNotFoundException {
        return null;
    }

    @Override
    public boolean copyFile(Context context, CopyFileRequest copyFileRequest) {
        return false;
    }
}
