package com.maniu.sandboxframework.fileaccess;

import android.content.Context;
import android.os.ParcelFileDescriptor;

import com.maniu.sandboxframework.responce.FileResponse;
import com.maniu.sandboxframework.resquest.CopyFileRequest;
import com.maniu.sandboxframework.resquest.DeleteFileRequest;
import com.maniu.sandboxframework.resquest.NewFileRequest;
import com.maniu.sandboxframework.resquest.OpenFileRequest;
import com.maniu.sandboxframework.resquest.RenameToFileRequest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;

public interface FileAccessInterface {
    /**
     * @param context Context
     * @param request NewFileRequest
     * @return ParcelFileDescriptor
     * @throws FileNotFoundException FileNotFoundException
     */
    ParcelFileDescriptor openFile(Context context, OpenFileRequest request)
            throws FileNotFoundException;

    /**
     * newCreateFile()
     *
     * @param context Context
     * @param request context
     * @return FileResponse
     */
    FileResponse newCreateFile(Context context, NewFileRequest request);


    /**
     * delete file
     *
     * @param context context
     * @param request DeleteFileRequest
     * @return boolean
     */
    boolean delete(Context context, DeleteFileRequest request);

    /**
     * file.renameToe
     *
     * @param context       Context
     * @param renameRequest RenameToFileRequest
     * @return boolean
     */
    FileResponse renameTo(Context context, RenameToFileRequest renameRequest);

    /**
     * mkdirs
     *
     * @param context Context
     * @param file    File
     * @return FileResponse
     */

    boolean mkdirs(Context context, File file);


    /**
     * getInputStream
     *
     * @param context Context
     * @param request NewFileRequest
     * @return InputStream
     * @throws FileNotFoundException FileNotFoundException
     */
    InputStream getInputStream(Context context, OpenFileRequest request)
            throws FileNotFoundException;

    /**
     * getOutStream
     *
     * @param context Context
     * @param request NewFileRequest
     * @return InputStream
     */
    OutputStream getOutStream(Context context, OpenFileRequest request)
            throws FileNotFoundException;


    /**
     * copyFile
     *
     * @param context         Context
     * @param copyFileRequest CopyFileRequest
     * @return FileResponse
     */
    boolean copyFile(Context context, CopyFileRequest copyFileRequest);
}
