package com.maniu.maniurecyclerview;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.List;

public class RecyclerView extends ViewGroup {
    private static final String TAG = "david";

//  协调  Adapter    和  回收池之间的工作

    private Adapter adapter;
    private RecycledViewPool recycledViewPool;
    //    当前reclerView的宽度
    private int width;
    //    当前reclerView的高度
    private int height;
// 不一样 简便   item 先把 每一个Item的高度先写死
    private int[] heights;
    //控制onLayout初始化次数
    private boolean needRelayout = true;
    //行数
    private int rowCount;
//    缓存当前显示的Item
    private List<ViewHolder> viewList;
    //最小滑动距离
    private int touchSlop;
    //当前滑动的y值
    private int currentY;
    //y偏移量      内容偏移量
    private int scrollY;
    //view的弟一行  是占内容的几行
    private int firstRow=0;
    /**
     * @param context
     *  容器====》很少实现onDraw
     适配器
     */
    public RecyclerView(Context context) {
        super(context);
    }

    public RecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        viewList = new ArrayList<>();
        ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
        this.touchSlop =viewConfiguration.getScaledTouchSlop();
    }
//设置适配器  得到的   初始化  1
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
        needRelayout = true;
        recycledViewPool = new RecycledViewPool();
        requestLayout();
    }
//初始化  2   是比较好性能  系统不断的调用
//    onLayout adapter
    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (needRelayout || changed) {
            needRelayout = false;

            if (adapter != null) {
                width = r - l;
                height = b - t;
            }
//            摆放  每一个控件 的宽高
            rowCount = adapter.getItemCount();
//            david
            heights = new int[rowCount];
            for (int i=0;i<heights.length;i++) {
                heights[i]=adapter.getHeight(i);
            }
            //            摆放  rowCount 20000
            int left, top = 0, right, bottom;
            for (int i = 0; i < rowCount&&top<height; i++) {
                bottom = top + heights[i];
//摆放---》View   生成View
                ViewHolder viewHolder=makeAndStep(i, 0, top, width, bottom);
                viewList.add(viewHolder);
//                遍历条件
                top = bottom;
            }
        }
    }
    private ViewHolder makeAndStep(int row, int left, int top, int right, int bottom) {
//产生ViewHodler
        ViewHolder viewHolder = obtainView(row, right - left, bottom - top);
//        摆放 完成了
        viewHolder.itemView.layout(left, top, right, bottom);
        return viewHolder;
    }
    private ViewHolder obtainView(int row, int width, int height) {
//      类型  用户  1   架构 2
        int itemType=adapter.getItemViewType(row);
//        第一屏数据
        ViewHolder viewHolder=recycledViewPool.getRecyclerView(itemType);
        if (viewHolder == null) {
            viewHolder = adapter.onCreateViewHolder(this, itemType);
        }
//        更新数据 内存
        adapter.onBindViewHolder(viewHolder, row);
        viewHolder.setmItemViewType(itemType);
        viewHolder.itemView.measure(MeasureSpec.makeMeasureSpec(width, MeasureSpec.EXACTLY)
                , MeasureSpec.makeMeasureSpec(height, MeasureSpec.EXACTLY));
        addView(viewHolder.itemView, 0);
        return viewHolder;
    }


//    滑动事件     点击事件    定向拦截       需 要 1  不需要 2

//    难  事件   迈步 onTouchEvent 隔多少时间   px
//    onTouchEvent
    @Override
    public boolean onTouchEvent(MotionEvent event) {
//        滑动
        switch (event.getAction()) {
            case MotionEvent.ACTION_MOVE: {
                int y2 = (int) event.getRawY();

                int diff = (int) (currentY - event.getRawY());
                scrollBy(0, diff);
            }

        }
        return super.onTouchEvent(event);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        boolean intercept = false;
        switch (event.getAction()) {
            case MotionEvent.ACTION_DOWN: {
                currentY = (int) event.getRawY();
                break;
            }
            case MotionEvent.ACTION_MOVE: {
                int y2 = (int) Math.abs(currentY - event.getRawY());
                if (y2 > touchSlop) {
                    intercept = true;
                }
                break;
            }
        }
        return intercept;
    }
//只对 canvas进行滚动
//    容器   重新摆放每一个子控件
    @Override
    public void scrollBy(int x, int y) {
//        摆放
        scrollY += y;

//        上滑
        if (scrollY > 0) {
            while (scrollY > heights[firstRow]) {
//                上面个
//                扔到回收池
//                firstRow++
                if (!viewList.isEmpty()) {
                    removeView(viewList.remove(0));
                }
                scrollY -= heights[firstRow];
                firstRow++;
                Log.i(TAG, "移除一个元素 ");
            }
            while (getFilledHeight() < height) {
//                需要被添加  滑动   肯定不是第一屏数据
                int dataIndex = firstRow + viewList.size();
                ViewHolder viewHolder=obtainView(dataIndex, width, heights[dataIndex]);
                viewList.add(viewList.size(),viewHolder);
                Log.i(TAG, "添加一个元素 ");
            }
//            上滑 顶端 溢出一个元素         底部 可能 不会添加的情况
        }

//        上滑        下一节课  摆放  下滑  +极限值判断  +  惯性滑动

    }
    private int getFilledHeight() {

        return sumArray(heights, firstRow, viewList.size()) - scrollY;

    }
//累加算法    firstIndex    firstIndex+count 结束  结果sum
    private int sumArray(int array[], int firstIndex, int count) {
        int sum = 0;
        count += firstIndex;
        for (int i = firstIndex; i < count; i++) {
            sum += array[i];
        }
        return sum;
    }

    private void removeView(ViewHolder remove) {
        recycledViewPool.putRecycledView(remove);
        removeView(remove.itemView);
    }

    interface  Adapter<VH extends  ViewHolder>{
        VH onCreateViewHolder(ViewGroup parent, int viewType);
        VH  onBindViewHolder(VH viewHodler, int position);
        //Item的类型
        int getItemViewType(int position);
        int getItemCount();
        public int getHeight(int index);
    }
}
