####  归并排序原理与实现

 二、归并排序（Merge Sort）

归并排序，是创建在归并操作上的一种有效的排序算法。算法是采用分治法（Divide and Conquer）的一个非常典型的应用，且各层分治递归可以同时进行。归并排序思路简单，速度仅次于快速排序，为稳定排序算法，一般用于对总体无序，但是各子项相对有序的数列。

##### 1.1  基本思想

归并排序是用分治思想，分治模式在每一层递归上有三个步骤：

- **分解（Divide）**：将n个元素分成个含n/2个元素的子序列。
- **解决（Conquer）**：用合并排序法对两个子序列递归的排序。
- **合并（Combine）**：合并两个已排序的子序列已得到排序结果。

##### 2  实现逻辑

**2.1 迭代法**

> ① 申请空间，使其大小为两个已经排序序列之和，该空间用来存放合并后的序列
> ② 设定两个指针，最初位置分别为两个已经排序序列的起始位置
> ③ 比较两个指针所指向的元素，选择相对小的元素放入到合并空间，并移动指针到下一位置
> ④ 重复步骤③直到某一指针到达序列尾
> ⑤ 将另一序列剩下的所有元素直接复制到合并序列尾

**2.2 递归法**

> ① 将序列每相邻两个数字进行归并操作，形成floor(n/2)个序列，排序后每个序列包含两个元素
> ② 将上述序列再次归并，形成floor(n/4)个序列，每个序列包含四个元素
> ③ 重复步骤②，直到所有元素排序完毕



2.3动态演示

![img](img/归并合成.gif)

##### 3 Java代码实现

```cpp
public static void mergeSort(int[] arr) {
    sort(arr, 0, arr.length - 1);
}

public static void sort(int[] arr, int L, int R) {
    if(L == R) {
        return;
    }
    int mid = L + ((R - L) >> 1);
    sort(arr, L, mid);
    sort(arr, mid + 1, R);
    merge(arr, L, mid, R);
}

public static void merge(int[] arr, int L, int mid, int R) {
    int[] temp = new int[R - L + 1];
    int i = 0;
    int p1 = L;
    int p2 = mid + 1;
    // 比较左右两部分的元素，哪个小，把那个元素填入temp中
    while(p1 <= mid && p2 <= R) {
        temp[i++] = arr[p1] < arr[p2] ? arr[p1++] : arr[p2++];
    }
    // 上面的循环退出后，把剩余的元素依次填入到temp中
    // 以下两个while只有一个会执行
    while(p1 <= mid) {
        temp[i++] = arr[p1++];
    }
    while(p2 <= R) {
        temp[i++] = arr[p2++];
    }
    // 把最终的排序的结果复制给原数组
    for(i = 0; i < temp.length; i++) {
        arr[L + i] = temp[i];
    }
}
```

##### 1.3 复杂度

- **时间复杂度：O(nlogn)**
- **空间复杂度：O(N)**，归并排序需要一个与原数组相同长度的数组做辅助来排序
- **稳定性：**归并排序是稳定的排序算法，`temp[i++] = arr[p1] <= arr[p2] ? arr[p1++] : arr[p2++];`这行代码可以保证当左右两部分的值相等的时候，先复制左边的值，这样可以保证值相等的时候两个元素的相对位置不变。

  
