package com.maniu.maniufix;

import android.content.Context;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;

import dalvik.system.DexFile;

public class DexManager {
    static {
        System.loadLibrary("native-lib");
    }

    private Context context;

    public DexManager(Context context) {
        this.context = context;
    }
    private void fixClazz(Class realClazz) throws  Exception {
        Method[] methods=  realClazz.getMethods();
        for (Method rightMethod : methods) {
            Replace replace=  rightMethod.getAnnotation(Replace.class);
            if (replace == null) {
                continue;
            }
            String clazzName = replace.clazz();
            String methodName = replace.method();
            Class wrongClazz = Class.forName(clazzName);
            Method wrongMethod = wrongClazz.getDeclaredMethod(methodName, rightMethod.getParameterTypes());
            repalce(wrongMethod, rightMethod);

        }
    }
    public void load(File file) {
        try {
            DexFile dexFile = DexFile.loadDex(file.getAbsolutePath(),
                    new File(context.getCacheDir(), "odex").getAbsolutePath(), Context.MODE_PRIVATE);
            Enumeration<String> entry = dexFile.entries();
            while (entry.hasMoreElements()) {
                String className = entry.nextElement();
//                Class.forName(className);//className   ---网络下载
                Class realClazz = dexFile.loadClass(className, context.getClassLoader());
                if (realClazz != null) {
                    try {
                        fixClazz(realClazz);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

    }



    public native static void repalce(Method wrongMethod, Method rightMethod);
}
