package com.maniu.sort;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SortMain {
    public static void main(String[] args) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        SortMain s1 = new SortMain();
        System.out.println("少量数据");

        int arraySize = 50000;
//        插入排序
        int[] test1 = new int[arraySize];
        int[] test2 = new int[arraySize];
        int[] test3 = new int[arraySize];
        int[] test4 = new int[arraySize];
        SortMain sorttest = new SortMain();
        // 正序  原始数据
        for (int i = 0; i < arraySize; i++) {
            test1[i] = i;
        }
        // 倒序原始数据
        for (int i = 0; i < arraySize; i++) {
            test2[i] = arraySize - i;
        }
        // 乱序,随机,基本无重复元素 原始数据
        for (int i = 0; i < arraySize; i++) {
            test3[i] = (int) (Math.random() * arraySize);
        }
        // 大量重复元素  原始数据
        for (int i = 0; i < arraySize; i++) {
            test4[i] = i + 50 % 50;
        }

        long start =  System.currentTimeMillis();
        insertionSort(test1);
        System.out.println("插入排序  正序 " + ( System.currentTimeMillis() - start));
          start =  System.currentTimeMillis();
        insertionSort(test2);
        System.out.println("插入排序  倒序 " + ( System.currentTimeMillis() - start));
          start =  System.currentTimeMillis();
        insertionSort(test3);
        System.out.println("插入排序  随机 " + ( System.currentTimeMillis() - start));
          start =  System.currentTimeMillis();
        insertionSort(test4);
        System.out.println("插入排序  大量重复元素 " + ( System.currentTimeMillis() - start));
        /**
         * -----------------------冒泡排序----------------------------------------------------------
         */
        start =  System.currentTimeMillis();
        bubbleSort(test1);
        System.out.println("冒泡排序  正序 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        bubbleSort(test2);
        System.out.println("冒泡排序  倒序 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        bubbleSort(test3);
        System.out.println("冒泡排序  随机 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        bubbleSort(test4);
        System.out.println("冒泡排序  大量重复元素 " + ( System.currentTimeMillis() - start));


        /**
         * -----------------------希尔排序----------------------------------------------------------
         */
        start =  System.currentTimeMillis();
        shellSort(test1);
        System.out.println("希尔排序  正序 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        shellSort(test2);
        System.out.println("希尔排序  倒序 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        shellSort(test3);
        System.out.println("希尔排序  随机 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        shellSort(test4);
        System.out.println("希尔排序  大量重复元素 " + ( System.currentTimeMillis() - start));



        /**
         * -----------------------堆排序----------------------------------------------------------
         */
        start =  System.currentTimeMillis();
        heapSort(test1);
        System.out.println("堆排序  正序 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        heapSort(test2);
        System.out.println("堆排序  倒序 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        heapSort(test3);
        System.out.println("堆排序  随机 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        heapSort(test4);
        System.out.println("堆排序  大量重复元素 " + ( System.currentTimeMillis() - start));
        /**
         * -----------------------归并排序----------------------------------------------------------
         */
        start =  System.currentTimeMillis();
        mergeSort(test1);
        System.out.println("归并排序  正序 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        mergeSort(test2);
        System.out.println("归并排序  倒序 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        mergeSort(test3);
        System.out.println("归并排序  随机 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        mergeSort(test4);
        System.out.println("归并排序  大量重复元素 " + ( System.currentTimeMillis() - start));

        /**
         * -----------------------归并排序----------------------------------------------------------
         */
        start =  System.currentTimeMillis();
        countSort1(test1);
        System.out.println("桶排序  正序 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        countSort1(test2);
        System.out.println("桶排序  倒序 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        countSort1(test3);
        System.out.println("桶排序  随机 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        countSort1(test4);
        System.out.println("桶排序  大量重复元素 " + ( System.currentTimeMillis() - start));

        /**
         * -----------------------快速排序----------------------------------------------------------
         */
        start =  System.currentTimeMillis();
        quickSort(test1);
        System.out.println("快速排序  正序 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        quickSort(test2);
        System.out.println("快速排序  倒序 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        quickSort(test3);
        System.out.println("快速排序  随机 " + ( System.currentTimeMillis() - start));
        start =  System.currentTimeMillis();
        quickSort(test4);
        System.out.println("快速排序  大量重复元素 " + ( System.currentTimeMillis() - start));



    }


    public static int[] countSort1(int[] arr){
//        -12 -21-- 32   -32  -1
        int max = Integer.MIN_VALUE;//  最小
        int min = Integer.MAX_VALUE;

        //找出数组中的最大最小值
        for(int i = 0; i < arr.length; i++){
            max = Math.max(max, arr[i]);
            min = Math.min(min, arr[i]);
        }
//桶   -的数量----》
        int help[] = new int[max];

        //找出每个数字出现的次数
        for(int i = 0; i < arr.length; i++){
//            做偏移   存    取 min= 2
            int mapPos = arr[i] - min;
            help[mapPos]++;
        }
//桶排序在这里 排序的数据    数据  存放索引


//       3   还原数据  min=-2
        int index = 0;
        for(int i = 0; i < help.length; i++){
            while(help[i]-- > 0){
                arr[index++] = i+min;
            }
        }

        return arr;
    }
    // 插入排序,稳定排序
    // 插入排序由N-1趟排序组成,时间最好O(n),最坏O(n2),平均O(n2)
    // 空间O(1)
    public static  void insertionSort(int[] nums) {
//        代码量最少   for最少  2层
        int j, p;
        int tmp;
        for (p = 1; p < nums.length; p++) {
            tmp = nums[p];
            for (j = p; j > 0; j--) {
                if (nums[j - 1] > tmp)
                    nums[j] = nums[j - 1];
            }
            nums[j] = tmp;
        }
    }

    // 冒泡排序,稳定排序
    // 时间最好O(n),最坏O(n2),平均O(n2)
    // 空间O(1)
    public static  void bubbleSort(int[] nums) {
        int j, p;
        int tmp;
        // 沉水,大数被移动到尾段
        for (p = 0; p < nums.length - 1; p++) {
            for (j = 0; j < nums.length - 1 - p; j++) {
                if (nums[j] > nums[j + 1]) {
                    tmp = nums[j];
                    nums[j] = nums[j + 1];
                    nums[j + 1] = tmp;
                }
            }
        }
        // //气泡,小数浮动到首段
        // for(p = 0; p < nums.length - 1;p++){
        // for(j = nums.length - 1;j > p;j--){
        // if(nums[j-1] > nums[j]){
        // tmp = nums[j];
        // nums[j] = nums[j-1];
        // nums[j-1] = tmp;
        // }
        // }
        // }
    }

    // 希尔排序(缩小增量排序),不稳定排序
    // 属于插入排序,时间最好O(n),最坏O(n2),平均O(n1.3)
    // 空间O(1)
    public static void shellSort(int[] nums) {
        int gap = 1; // 增量
        int i, j;
        int len = nums.length;
        int tmp;
        // 初始增量,shell排序的效率与增量设定有很大关系
        while (gap < len / 3)
            gap = gap * 3 + 1;
        for (; gap > 0; gap /= 3) {
            for (i = gap; i < len; i++) {
                tmp = nums[i];
                for (j = i - gap; j >= 0 && nums[j] > tmp; j -= gap)
                    nums[j + gap] = nums[j];
                nums[j + gap] = tmp;
            }
        }
    }

    // 堆排序,不稳定排序
    // 时间 平均2nlogn - O(nlogn)
    // 空间O(1)
    // 排序方式
    // 创建一个堆H[0..n-1]
    // 把堆首（最大值）和堆尾互换
    // 把堆的尺寸缩小1，并调用shift_down(0),目的是把新的数组顶端数据调整到相应位置
    // 重复步骤2，直到堆的尺寸为1
    public static void heapSort(int[] nums) {
        int i;
        // 遍历所有结点,对不满足规则节点进行调整
        for (i = nums.length / 2; i >= 0; i--) {
            PercDown(nums, i, nums.length);
        }
        for (i = nums.length - 1; i > 0; i--) {
            int tmp = nums[0];
            nums[0] = nums[i];
            nums[i] = tmp;
            PercDown(nums, 0, i);
        }
    }

    // 调整堆序
    public  static void PercDown(int[] nums, int i, int length) {
        int child;
        int tmp;

        for (tmp = nums[i]; 2 * i + 1 < length; i = child) {
            child = 2 * i + 1; // 左儿子
            if (child != length - 1 && nums[child + 1] > nums[child])
                child++; // 选出左右子结点中的较大值
            if (tmp < nums[child]) { // 父节点小于子节点,需要进行调整
                nums[i] = nums[child];
            } else
                break;
        }
        nums[i] = tmp;
    }

    // 归并排序
    public static  void mergeSort(int[] nums) {
        int[] tmpArray = new int[nums.length];
        mSort(nums, tmpArray, 0, nums.length - 1);
    }

    public static  void mSort(int[] nums, int[] tmps, int left, int right) {
        int center;
        if (left < right) {
            center = (left + right) / 2;
            mSort(nums, tmps, left, center);
            mSort(nums, tmps, center + 1, right);
            merge(nums, tmps, left, center + 1, right);
        }
    }

    // 空间归并
    public static void merge(int[] nums, int[] tmps, int lpos, int rpos, int rightEnd) {
        int i, leftEnd, numElements, tmpPos;
        leftEnd = rpos - 1;
        tmpPos = lpos;
        numElements = rightEnd - lpos + 1;
        while (lpos <= leftEnd && rpos <= rightEnd) {
            if (nums[lpos] <= nums[rpos])
                tmps[tmpPos++] = nums[lpos++];
            else
                tmps[tmpPos++] = nums[rpos++];
        }
        while (lpos <= leftEnd)
            tmps[tmpPos++] = nums[lpos++];
        while (rpos <= rightEnd)
            tmps[tmpPos++] = nums[rpos++];
        for (i = 0; i < numElements; i++, rightEnd--)
            nums[rightEnd] = tmps[rightEnd];
    }

    // 快速排序
    // 理论上能保证不出现最坏情况:三数中值分割法
    // 小规模排序,快速排序不如插入排序
    public static void quickSort(int[] nums) {
        qSort(nums, 0, nums.length - 1);
    }

    // 递归快速排序
    public static void qSort(int[] nums, int left, int right) {
        int i, j;
        int pivot;

        if (left + 3 <= right) { // 至少有4个数
            pivot = median3(nums, left, right);
            i = left;
            j = right - 1;
            while (true) {
                // 先推进索引再判断,而不是先判断再决定要不要推进索引
                // 这样避免了a[i]=a[j]=pivot,导致索引不会被推进,也不会跳出循环
                while (nums[++i] < pivot) {
                }
                while (nums[--j] > pivot) {
                }
                if (i < j) {
                    int tmp = nums[i];
                    nums[i] = nums[j];
                    nums[j] = tmp;
                } else
                    break;
            }
            int tmp = nums[i];
            nums[i] = nums[right - 1];
            nums[right - 1] = tmp;
            qSort(nums, left, i - 1);
            qSort(nums, i + 1, right);
        }
        // 少于4个数,不再分割,用插入排序直接排序
        else {
            int k, p;
            int tmp;
            for (p = 1; p < right - left + 1; p++) {
                tmp = nums[left + p];
                for (k = p; k > 0; k--) {
                    if (nums[left + k - 1] > tmp)
                        nums[left + k] = nums[left + k - 1];
                }
                nums[left + k] = tmp;
            }
        }
    }

    // 分割数组
    public static int  median3(int[] nums, int left, int right) {
        int center = (left + right) / 2;

        if (nums[left] > nums[center]) {
            int tmp = nums[left];
            nums[left] = nums[center];
            nums[center] = tmp;
        }
        if (nums[left] > nums[right]) {
            int tmp = nums[left];
            nums[left] = nums[right];
            nums[right] = tmp;
        }
        if (nums[center] > nums[right]) {
            int tmp = nums[center];
            nums[center] = nums[right];
            nums[right] = tmp;
        }
        int tmp = nums[center];
        nums[center] = nums[right - 1];
        nums[right - 1] = tmp;
        return nums[right - 1];
    }

}