package com.maniu.sort;

import java.io.File;
import java.util.LinkedList;
import java.util.Queue;

public class SercharGuangFile {
    public static void main(String[] args) {
        File file = new File(System.getProperty("user.dir"));
        System.out.println(file.getAbsolutePath());
//        String path = "E:\\project\\demo";
        long start = System.currentTimeMillis();
        bfsSearchFile(file.getAbsolutePath(), "MainActivity", false, true);
        System.out.println("广度优先搜索  :"+(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        FindFile(file.getAbsolutePath(), "MainActivity");
        System.out.println("深度优先搜索  :"+(System.currentTimeMillis() - start));
    }

    public static  void FindFile (String parentDir,String filename) {

        File file = new File(parentDir);//文件路径关联
        File filelist[] = file.listFiles();//定义一个列表接收file.listFiles搜索出来的所有文件以及文件夹

        for (int i = 0; i < filelist.length; i++) {//遍历filelist里面的内容
            if (filelist[i].isFile()) {//判断如果是文件

                if(filelist[i].getName().contains(filename)) {// 判断关键字是否在文件名里
//                    System.out.println(filelist[i].getAbsolutePath());//如果是的话就打印它的文件名
                }
            }else {
                FindFile(filelist[i].getAbsolutePath(),filename); //如果文件夹，就递归执行FindFile方法
            }
        }
    }


    private static void bfsSearchFile(String path,String regex,boolean isDisplyDir,boolean isDisplayFile)
    {
        if(!(isDisplayFile||isDisplyDir))
        {
            throw new IllegalArgumentException("isDisplyDir和isDisplayFile中至少要有一个为true");
        }
        Queue<File> queue=new LinkedList<>();
        File[] fs=new File(path).listFiles();
        //遍历第一层
        for(File f:fs)
        {
            //把第一层文件夹加入队列
            if(f.isDirectory())
            {
                queue.offer(f);
            }
            else
            {
                if(f.getName().contains(regex)&&isDisplayFile)
                {
                    System.out.println(f.getAbsolutePath());
                }
            }
        }
        //逐层搜索下去
        while (!queue.isEmpty()) {
            File fileTemp=queue.poll();//从队列头取一个元素
            if(isDisplyDir)
            {
                if(fileTemp.getName().matches(regex))
                {
                    System.out.println(fileTemp.getAbsolutePath());
                }
            }

            File[] fileListTemp=fileTemp.listFiles();
            if(fileListTemp==null)
                continue;//遇到无法访问的文件夹跳过
            for(File f:fileListTemp)
            {
                if(f.isDirectory())
                {
                    queue.offer(f);////从队列尾插入一个元素
                }
                else
                {
                    if(f.getName().contains(regex)&&isDisplayFile)
                    {
//                        System.out.println(f.getAbsolutePath());
                    }
                }
            }

        }
    }
}
