package com.maniu.personage;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.os.Bundle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MainActivity extends AppCompatActivity {
    private List<Person> fruitList = new ArrayList<>();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        initData();
        RecyclerView recyclerView = (RecyclerView) findViewById(R.id.recycler_view);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this);
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        recyclerView.setLayoutManager(layoutManager);
        sort(fruitList);
        PersonAdapter adapter = new PersonAdapter(fruitList);

        recyclerView.setAdapter(adapter);
        Demo demo = new Demo();
        Demo demo1 = new Demo();
        Demo demo2 = new Demo();
        demo2.run();
//        对象----》class
        demo.run();
    }

    private void initData() {

        Person apple = new Person(18, "99号技师");
        fruitList.add(apple);
        apple = new Person(14, "98号技师");
        fruitList.add(apple);
        apple = new Person(17, "90号技师");
        fruitList.add(apple);
        apple = new Person(26, "78号技师");
        fruitList.add(apple);
        apple = new Person(18, "99号技师");
        fruitList.add(apple);
        apple = new Person(25, "30号技师");
        fruitList.add(apple);
        apple = new Person(30, "101号技师");
        fruitList.add(apple);
        apple = new Person(17, "111号技师");
        fruitList.add(apple);
        apple = new Person(56, "45号技师");
        fruitList.add(apple);
        apple = new Person(60, "47号技师");
        fruitList.add(apple);
        apple = new Person(30, "101号技师");
        fruitList.add(apple);
        apple = new Person(32, "56号技师");
        fruitList.add(apple);
        apple = new Person(16, "131号技师");
        fruitList.add(apple);
        apple = new Person(17, "188号技师");
        fruitList.add(apple);

    }
//排序  ---》   背下来  思路一定要理解
    public static void sort(List<Person> personList) {
//        步长  4 - 2  -1        16 - 8 -4 -2 -1
        int N = personList.size() / 2;
        int k = 1;
        while (N >= 1) {
            for (int i = N; i < personList.size(); i++) {
                insertNum(personList, N, i);
            }
            N = N / 2;
            System.out.println("第" + k++ + "趟：" + Arrays.toString(personList.toArray()));
        }

    }

    private static void insertNum(List<Person> personList, int gap, int i) {
        Person start;
        int step;
        start = personList.get(i);
        step = i - gap;
        //直接插入排序，会向前找所适合的位置
        while (step >= 0 && personList.get(step).getAge() > start.getAge()) {
            //交换位置
            personList.set(step + gap, personList.get(step));
            step = step - gap;
        }
        personList.set(step + gap, start);
    }

    /**
     * 冒泡排序
     */
    public List<Person> bubbleSort(List<Person> array) {
        if (array.size() == 0)
            return array;
        for (int i = 0; i < array.size(); i++)
            for (int j = 0; j < array.size() - 1 - i; j++)
                if (array.get(j + 1).getAge() < array.get(j).getAge()) {
                    swap(array, j, j + 1);
                }
        return array;
    }

    public void swap(List<Person> list, int i, int j) {
        Person temp = list.get(j);
        list.set(j, list.get(i));
        list.set(i, temp);
    }
}
