package com.maniu.threaddemo;

import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadPoolImpl implements IThreadPool {
    static int WORKER_NUMBER = 5;
    static volatile int sumCount = 0;
    static PriorityBlockingQueue<Runnable> taskQueue = new PriorityBlockingQueue<Runnable>();
    WorkerThread[] workThreads;
    static AtomicLong threadNum = new AtomicLong();
    static ThreadPoolImpl threadPool;

    public ThreadPoolImpl() {
        this(WORKER_NUMBER);
    }

    public ThreadPoolImpl(int workerNum) {
        this.WORKER_NUMBER = workerNum;
        workThreads = new WorkerThread[WORKER_NUMBER];
        for (int i = 0; i < WORKER_NUMBER; i++) {
            workThreads[i] = new WorkerThread();
            Thread thread = new Thread(workThreads[i], "ThreadPool-worker" + threadNum.incrementAndGet());
            System.out.println("初始化线程数" + (i + 1) + "---------当前线程名称:" + thread.getName());
            thread.start();
        }
    }

    @Override
    public void execute(Runnable task) {
        taskQueue.add(task);
        taskQueue.notifyAll();
    }

    @Override
    public void execute(Runnable[] tasks) {
        for (Runnable task : tasks) {
            taskQueue.add(task);
        }
        taskQueue.notifyAll();
    }

    public static IThreadPool getThreadPool() {
        return getThreadPool(WORKER_NUMBER);
    }

    public static IThreadPool getThreadPool(int workerNum) {
        if (workerNum <= 0) {
            workerNum = WORKER_NUMBER;
        }
        if (threadPool == null) {
            threadPool = new ThreadPoolImpl(workerNum);
        }
        return threadPool;
    }

    @Override
    public void execute(List<Runnable> tasks) {
        for (Runnable task : tasks) {
            taskQueue.add(task);
        }
        System.out.println("添加完毕 "+taskQueue.size());
    }

    @Override
    public void destroy() {
        while (!taskQueue.isEmpty()) {
            try {
                Thread.sleep(20);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < WORKER_NUMBER; i++) {
            workThreads[i].setWorkerFlag();
            workThreads[i] = null;
        }
        threadPool = null;
        taskQueue.clear();
    }

    class WorkerThread extends Thread {
        private boolean isRunning = true;

        @Override
        public void run() {
            Runnable runnable = null;
            while (isRunning) {

                    synchronized (WorkerThread.class) {
                        System.out.println("---taskQueue大小  " + taskQueue.size());
                        try {
                            runnable = taskQueue.take();//获取第一个任务
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                            System.out.println("----->异常");
                        }
                        System.out.println("取出之后taskQueue大小  " + taskQueue.size());
                    }
                    if (runnable != null) {
                        runnable.run();
                    }
                    sumCount++;
                    runnable = null;
            }

        }

        public void setWorkerFlag() {
            isRunning = false;
        }
    }
}
