package com.maniu.reentrantlocktest;

import java.util.concurrent.locks.LockSupport;

public class LockSupportDemo {

    public static Object u = new Object();
    static ChangeObjectThread t1 = new ChangeObjectThread("t1");
    static ChangeObjectThread t2 = new ChangeObjectThread("t2");

    public static class ChangeObjectThread extends Thread {
        public ChangeObjectThread(String name) {
            super(name);
        }
        @Override public void run() {
            synchronized (u) {
                System.out.println("in " + getName());
//                休眠
                LockSupport.park();
//                不会往下执行
                if (Thread.currentThread().isInterrupted()) {
                    System.out.println("被中断了");
                }
                System.out.println("继续执行");
            }
        }
    }

    public static void main(String[] args) throws InterruptedException {
//        t1.start();
//        Thread.sleep(1000L);
        t2.start();
        Thread.sleep(3000L);
        LockSupport.unpark(t2);
        t1.join();
        t2.join();
    }
}