package com.maniu.reentrantlocktest;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

//公平锁
public class DavidReentrantLock {
    private final AtomicBoolean locked = new AtomicBoolean();
    private Queue<Thread> waiters = new ConcurrentLinkedQueue<>();

    public void lock() {
        Thread current = Thread.currentThread();
        waiters.add(current);

        while (waiters.peek() != current || !locked.compareAndSet(false, true)) {
//            进来了     假设  休眠
            LockSupport.park(this);
        }
        waiters.remove();

    }
    public void unlock() {
        locked.set(false);
        LockSupport.unpark(waiters.peek());
    }


}
