堆内存溢出示例代码

```
public class Heap
{
    public static void main(String[] args)
    {
        ArrayList list=new ArrayList();
        while(true)
        {
            list.add(new Heap());
        }
    }
}


```





项目常见情况

1  生产者与消费者 速率不一致。没有控制队列中最大size大小，导致堆内存溢出

2 JSONObject.toJSON(object) 来处理Javabean的，这样处理简单的对象是没有问题的，但是对象如果复杂的话就会发生一些问题。
object对象过于复杂和大量时，用toJSOn解析就会出现CPU、内存一直飙升，JVM一直执行GC操作，但是无法回收内存，最后会报
java.lang.OutOfMemoryError: GC overhead limit exceeded 错误。


内存抖动

优化内存抖动，核心就是防止频繁创建对象。常见的反面教材就是：循环中创建对象，大量调用的api中创建对象。而优化的主要手段，就是对象复用，常见的手段是：对象池，像是 Handler的Message 单链表池，Glide的bitmap池等。



      class Fruit {
      static int x = 10;
        static BigWaterMelon bigWaterMelon_1 = new BigWaterMelon(x);
        
        int y = 20;
        BigWaterMelon bigWaterMelon_2 = new BigWaterMelon(y);
        
        public static void main(String[] args) {
            
            final Fruit fruit = new Fruit();
            int z = 30;
            BigWaterMelon bigWaterMelon_3 = new BigWaterMelon(z);
            
            new Thread() {
                @Override
                public void run() {
                    int k = 100;
                    setWeight(k);
                }
     
                void setWeight(int waterMelonWeight) {
                    fruit.bigWaterMelon_2.weight = waterMelonWeight;
                }
            }.start();
        }
    }
    
    class BigWaterMelon {
     
        public BigWaterMelon(int weight) {
            this.weight = weight;
        }
     
        public int weight;
    }



回收验证

```
 package company;

public class Test1 {
    public static Test1 test;
    public void isAlive() {
        System.out.println("I am alive :)");
    }
    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        System.out.println("finalize method executed!");
        test = this;
    }
    public static void main(String[] args)throws Exception {
        test = new Test1();
        test = null;
        System.gc();
        Thread.sleep(500);
        if (test != null) {
            test.isAlive();
        }else {
            System.out.println("no,I am dead :(");
        }
        // 下面代码与上面完全一致，但是此次自救失败
        test = null;
        System.gc();
        Thread.sleep(500);
        if (test != null) {
            test.isAlive();
        }else {
            System.out.println("no,I am dead :(");
        }
    }
}
```




