# Android虚拟机原理02（art虚拟机替换dalvik虚拟机的原因）

> **码牛学院用代码码出自己牛逼的人生**



​		Dalvik虚拟机是2008年跟随Android系统一起发布的。当时的移动设备的系统内存只有64M左右，CPU频率在250~500MHz之间。这个硬件水平早已发生了巨大变化。

​		随着智能设备的兴起，这些年移动芯片的性能每年都有大幅提升。如今的智能手机内存已经有6G甚至8G至多。CPU也已经步入了64位的时代，频率高达2.0 GHz甚至更高。硬件的更新，常常也伴随着软件的换代。因此，Dalvik虚拟机被淘汰也是情理之中的事情。

##### 1.1 Dalvik之所以要被ART替代包含下面几个原因：

- Dalvik是为32位设计的，不适用于64位CPU。
- 单纯的字节码解释加JIT编译的执行方式，性能要弱于本地机器码的执行。
- 无论是解释执行还是JIT编译都是单次运行过程中发生，每运行一次都可能需要重新做这些工作，这样做太浪费资源。
- 原先的垃圾回收机制不够好，会导致卡顿。

很显然，ART虚拟机对上面提到的这些地方做了改进。除了支持64位不必说，最主要的是下面两项改进：

- **AOT编译**：Ahead-of-time（AOT）是相对于Just-in-time（JIT）而言的。JIT是在运行时进行字节码到本地机器码的编译，这也是为什么Java普遍被认为效率比C++差的原因。无论是解释器的解释还是运行过程中即时编译，都比C++编译出的本地机器码执行多了一个耗费时间的过程。而AOT就是向C++编译过程靠拢的一项技术：当APK在安装的时候，系统会通过一个名称为`dex2oat`的工具将APK中的dex文件编译成包含本地机器码的oat文件存放下来。这样做之后，在程序执行的时候，就可以直接使用已经编译好的机器码以加快效率。
- **垃圾回收的改进**：GC（Garbage Collection）是虚拟机非常重要的一个特性，因为它的实现好坏会影响所有在虚拟机上运行的应用。GC实现得不好可能会导致画面跳跃，掉帧，UI响应过慢等问题。ART的垃圾回收机制相较于Dalvik虚拟机有如下改进：
  - 将GC的停顿由2次改成1次
  - 在仅有一次的GC停顿中进行并行处理
  - 在特殊场景下，对于近期创建的具有较短生命的对象消耗更少的时间进行垃圾回收
  - 改进垃圾收集的工效，更频繁的执行并行垃圾收集
  - 对于后台进程的内存在垃圾回收过程进行压缩以解决碎片化的问题

AOT编译是在应用程序安装时就进行的工作，下图描述了Dalvik虚拟机与（Android 5.0上的）ART虚拟机在安装APK时的区别：

![art_vs_dalvik.png](http://qiangbo-workspace.oss-cn-shanghai.aliyuncs.com/AndroidNewFeatureBook/Chapter3/art_vs_dalvik.png)

两种虚拟机上安装APK时的流程 

##### 1.2 从这幅图中我们看到：

> - 在Dalvik虚拟机上，APK中的Dex文件在安装时会被优化成odex文件，在运行时，会被JIT编译器编译成native代码。
> - 而在ART虚拟机上安装时，Dex文件会直接由dex2oat工具翻译成oat格式的文件，oat文件中既包含了dex文件中原先的内容，也包含了已经编译好的native代码。
>

